/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.springframework.jms.core.JmsTemplate;

public class JmsTemplate102
extends JmsTemplate {
    public JmsTemplate102() {
    }

    public JmsTemplate102(ConnectionFactory connectionFactory, boolean pubSubDomain) {
        this.setConnectionFactory(connectionFactory);
        this.setPubSubDomain(pubSubDomain);
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.isPubSubDomain()) {
            if (!(this.getConnectionFactory() instanceof TopicConnectionFactory)) {
                throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 template for topics but did not supply an instance of TopicConnectionFactory");
            }
        } else if (!(this.getConnectionFactory() instanceof QueueConnectionFactory)) {
            throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 template for queues but did not supply an instance of QueueConnectionFactory");
        }
    }

    protected Connection createConnection() throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnectionFactory)this.getConnectionFactory()).createTopicConnection();
        }
        return ((QueueConnectionFactory)this.getConnectionFactory()).createQueueConnection();
    }

    protected Session createSession(Connection con) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnection)con).createTopicSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
        }
        return ((QueueConnection)con).createQueueSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
    }

    protected MessageProducer createProducer(Session session, Destination destination) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicSession)session).createPublisher((Topic)destination);
        }
        return ((QueueSession)session).createSender((Queue)destination);
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicSession)session).createSubscriber((Topic)destination);
        }
        return ((QueueSession)session).createReceiver((Queue)destination);
    }

    protected void doSend(MessageProducer producer, Message message) throws JMSException {
        if (this.isPubSubDomain()) {
            if (this.isExplicitQosEnabled()) {
                ((TopicPublisher)producer).publish(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
            } else {
                ((TopicPublisher)producer).publish(message);
            }
        } else if (this.isExplicitQosEnabled()) {
            producer.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        } else {
            producer.send(message);
        }
    }
}

