/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.springframework.util.ControlFlow;

class Jdk14ControlFlow
implements ControlFlow {
    private StackTraceElement[] stack = new Throwable().getStackTrace();

    public boolean under(Class clazz) {
        String className = clazz.getName();
        for (int i = 0; i < this.stack.length; ++i) {
            if (!this.stack[i].getClassName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public boolean under(Class clazz, String methodName) {
        String className = clazz.getName();
        for (int i = 0; i < this.stack.length; ++i) {
            if (!this.stack[i].getClassName().equals(className) || !this.stack[i].getMethodName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public boolean underToken(String token) {
        StringWriter sw = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        return stackTrace.indexOf(token) != -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Jdk14ControlFlow: ");
        for (int i = 0; i < this.stack.length; ++i) {
            if (i > 0) {
                sb.append("\n\t@");
            }
            sb.append(this.stack[i]);
        }
        return sb.toString();
    }
}

