/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.context.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.ui.context.NestingThemeSource;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.SimpleTheme;

public class ResourceBundleThemeSource
implements NestingThemeSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ThemeSource parent;
    private String basenamePrefix = "";
    private Map themes = new HashMap();

    public void setParent(ThemeSource parent) {
        this.parent = parent;
        Iterator it = this.themes.values().iterator();
        while (it.hasNext()) {
            this.initParent((Theme)it.next());
        }
    }

    public void setBasenamePrefix(String basenamePrefix) {
        this.basenamePrefix = basenamePrefix != null ? basenamePrefix : "";
    }

    public Theme getTheme(String themeName) {
        if (themeName == null) {
            return null;
        }
        Theme theme = (Theme)this.themes.get(themeName);
        if (theme == null) {
            ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
            this.logger.info((Object)("Theme created: name=" + themeName + ", baseName=" + this.basenamePrefix + themeName));
            messageSource.setBasename(this.basenamePrefix + themeName);
            theme = new SimpleTheme(themeName, messageSource);
            this.initParent(theme);
            this.themes.put(themeName, theme);
        }
        return theme;
    }

    protected void initParent(Theme theme) {
        ResourceBundleMessageSource messageSource = (ResourceBundleMessageSource)theme.getMessageSource();
        if (this.parent != null) {
            Theme parentTheme = this.parent.getTheme(theme.getName());
            if (parentTheme != null) {
                messageSource.setParent(parentTheme.getMessageSource());
            }
        } else {
            messageSource.setParent(null);
        }
    }
}

