/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class MessageSourceAccessor {
    private MessageSource messageSource;

    public MessageSourceAccessor(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getMessage(String code, String defaultMessage) {
        return this.messageSource.getMessage(code, null, defaultMessage, Locale.getDefault());
    }

    public String getMessage(String code, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code, null, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        return this.messageSource.getMessage(code, args, defaultMessage, Locale.getDefault());
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, null, Locale.getDefault());
    }

    public String getMessage(String code, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, null, locale);
    }

    public String getMessage(String code, Object[] args) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, args, Locale.getDefault());
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, Locale.getDefault());
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, locale);
    }
}

