/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NestingMessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.config.ApplicationContextAwareProcessor;
import org.springframework.context.config.ConfigurableApplicationContext;
import org.springframework.context.config.ContextResourceEditor;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ApplicationEventMulticasterImpl;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public abstract class AbstractApplicationContext
implements ConfigurableApplicationContext {
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext parent;
    private String displayName = this.getClass().getName() + ";hashCode=" + this.hashCode();
    private long startupTime;
    private MessageSource messageSource;
    private ApplicationEventMulticaster eventMulticaster = new ApplicationEventMulticasterImpl();
    static /* synthetic */ Class class$org$springframework$context$ApplicationContext;
    static /* synthetic */ Class class$org$springframework$core$io$Resource;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanFactoryPostProcessor;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanPostProcessor;
    static /* synthetic */ Class class$org$springframework$context$ApplicationListener;

    public AbstractApplicationContext() {
    }

    public AbstractApplicationContext(ApplicationContext parent) {
        this.parent = parent;
    }

    public ApplicationContext getParent() {
        return this.parent;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getStartupDate() {
        return this.startupTime;
    }

    public void publishEvent(ApplicationEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publishing event in context [" + this.getDisplayName() + "]: " + event.toString()));
        }
        this.eventMulticaster.onApplicationEvent(event);
        if (this.parent != null) {
            this.parent.publishEvent(event);
        }
    }

    public Resource getResource(String location) throws IOException {
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()));
        }
        try {
            URL url = new URL(location);
            return new UrlResource(url);
        }
        catch (MalformedURLException ex) {
            Resource resource = this.getResourceByPath(location);
            if (resource == null) {
                throw new FileNotFoundException("Location [" + location + "] could not be opened as path");
            }
            return resource;
        }
    }

    protected Resource getResourceByPath(String path) throws IOException {
        return new FileSystemResource(path);
    }

    public File getResourceBase() {
        return new File("").getAbsoluteFile();
    }

    public void setParent(ApplicationContext parent) {
        this.parent = parent;
    }

    public void refresh() throws BeansException {
        this.startupTime = System.currentTimeMillis();
        this.refreshBeanFactory();
        this.getBeanFactory().ignoreDependencyType(class$org$springframework$context$ApplicationContext == null ? (class$org$springframework$context$ApplicationContext = AbstractApplicationContext.class$("org.springframework.context.ApplicationContext")) : class$org$springframework$context$ApplicationContext);
        this.getBeanFactory().addBeanPostProcessor(new ApplicationContextAwareProcessor(this));
        this.getBeanFactory().registerCustomEditor(class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = AbstractApplicationContext.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource, new ContextResourceEditor(this));
        if (this.getBeanDefinitionCount() == 0) {
            this.logger.warn((Object)("No beans defined in ApplicationContext [" + this.getDisplayName() + "]"));
        } else {
            this.logger.info((Object)(this.getBeanDefinitionCount() + " beans defined in ApplicationContext [" + this.getDisplayName() + "]"));
        }
        this.invokeBeanFactoryPostProcessors();
        this.registerBeanPostProcessors();
        this.initMessageSource();
        this.onRefresh();
        this.refreshListeners();
        this.getBeanFactory().preInstantiateSingletons();
        this.publishEvent(new ContextRefreshedEvent(this));
    }

    private void invokeBeanFactoryPostProcessors() throws BeansException {
        int i;
        String[] beanNames = this.getBeanDefinitionNames(class$org$springframework$beans$factory$config$BeanFactoryPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanFactoryPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanFactoryPostProcessor")) : class$org$springframework$beans$factory$config$BeanFactoryPostProcessor);
        BeanFactoryPostProcessor[] factoryProcessors = new BeanFactoryPostProcessor[beanNames.length];
        for (i = 0; i < beanNames.length; ++i) {
            factoryProcessors[i] = (BeanFactoryPostProcessor)this.getBean(beanNames[i]);
        }
        Arrays.sort(factoryProcessors, new OrderComparator());
        for (i = 0; i < factoryProcessors.length; ++i) {
            BeanFactoryPostProcessor factoryProcessor = factoryProcessors[i];
            factoryProcessor.postProcessBeanFactory(this.getBeanFactory());
        }
    }

    private void registerBeanPostProcessors() throws BeansException {
        String[] beanNames = this.getBeanDefinitionNames(class$org$springframework$beans$factory$config$BeanPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanPostProcessor")) : class$org$springframework$beans$factory$config$BeanPostProcessor);
        if (beanNames.length > 0) {
            ArrayList<Object> beanProcessors = new ArrayList<Object>();
            for (int i = 0; i < beanNames.length; ++i) {
                beanProcessors.add(this.getBean(beanNames[i]));
            }
            Collections.sort(beanProcessors, new OrderComparator());
            Iterator it = beanProcessors.iterator();
            while (it.hasNext()) {
                this.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)it.next());
            }
        }
    }

    private void initMessageSource() throws BeansException {
        try {
            this.messageSource = (MessageSource)this.getBean(MESSAGE_SOURCE_BEAN_NAME);
            if (this.parent != null && this.messageSource instanceof NestingMessageSource && Arrays.asList(this.getBeanDefinitionNames()).contains(MESSAGE_SOURCE_BEAN_NAME)) {
                ((NestingMessageSource)this.messageSource).setParent(this.parent);
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.logger.info((Object)("No MessageSource found for [" + this.getDisplayName() + "]: using empty StaticMessageSource"));
            this.messageSource = new StaticMessageSource();
        }
    }

    protected void onRefresh() throws BeansException {
    }

    private void refreshListeners() throws BeansException {
        this.logger.info((Object)"Refreshing listeners");
        Collection listeners = this.getBeansOfType(class$org$springframework$context$ApplicationListener == null ? (class$org$springframework$context$ApplicationListener = AbstractApplicationContext.class$("org.springframework.context.ApplicationListener")) : class$org$springframework$context$ApplicationListener, true, false).values();
        this.logger.debug((Object)("Found " + listeners.size() + " listeners in bean factory"));
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ApplicationListener listener = (ApplicationListener)it.next();
            this.addListener(listener);
            this.logger.info((Object)("Application listener [" + listener + "] added"));
        }
    }

    protected void addListener(ApplicationListener l) {
        this.eventMulticaster.addApplicationListener(l);
    }

    public void close() {
        this.logger.info((Object)("Closing application context [" + this.getDisplayName() + "]"));
        this.getBeanFactory().destroySingletons();
        this.publishEvent(new ContextClosedEvent(this));
    }

    public Object getBean(String name) throws BeansException {
        return this.getBeanFactory().getBean(name);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBeanFactory().getBean(name, requiredType);
    }

    public boolean containsBean(String name) throws BeansException {
        return this.getBeanFactory().containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isSingleton(name);
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getAliases(name);
    }

    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    public String[] getBeanDefinitionNames(Class type) {
        return this.getBeanFactory().getBeanDefinitionNames(type);
    }

    public boolean containsBeanDefinition(String name) {
        return this.getBeanFactory().containsBeanDefinition(name);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type, includePrototypes, includeFactoryBeans);
    }

    public Object autowire(Class beanClass) throws BeansException {
        return this.getBeanFactory().autowire(beanClass);
    }

    public Object autowireConstructor(Class beanClass) throws BeansException {
        return this.getBeanFactory().autowireConstructor(beanClass);
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        this.getBeanFactory().autowireBeanProperties(existingBean, autowireMode, dependencyCheck);
    }

    public Object applyBeanPostProcessors(Object existingBean, String name) throws BeansException {
        return this.getBeanFactory().applyBeanPostProcessors(existingBean, name);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, locale);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ApplicationContext: displayName=[" + this.displayName + "]; ");
        sb.append("class=[" + this.getClass().getName() + "]; ");
        sb.append("beanFactory=[" + this.getBeanFactory() + "]; ");
        sb.append("messageSource=[" + this.messageSource + "]; ");
        sb.append("startup date=[" + new Date(this.startupTime) + "]; ");
        if (this.parent == null) {
            sb.append("root of ApplicationContext hierarchy");
        } else {
            sb.append("parent=[" + this.parent + "]");
        }
        return sb.toString();
    }

    protected abstract void refreshBeanFactory() throws BeansException;

    public abstract ConfigurableListableBeanFactory getBeanFactory();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

