/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean validating = true;
    private EntityResolver entityResolver;
    private Class parserClass = class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser == null ? (class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.DefaultXmlBeanDefinitionParser")) : class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$DefaultXmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$XmlBeanFactory;

    public XmlBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setParserClass(Class parserClass) {
        if (this.parserClass == null || !(class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser == null ? (class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.XmlBeanDefinitionParser")) : class$org$springframework$beans$factory$xml$XmlBeanDefinitionParser).isAssignableFrom(parserClass)) {
            throw new IllegalArgumentException("parserClass must be a XmlBeanDefinitionParser");
        }
        this.parserClass = parserClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadBeanDefinitions(Resource resource) throws BeansException {
        if (resource == null) {
            throw new BeanDefinitionStoreException("Resource cannot be null: expected an XML file");
        }
        InputStream is = null;
        try {
            try {
                this.logger.info((Object)("Loading XmlBeanFactory from resource [" + resource + "]"));
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.logger.debug((Object)("Using JAXP implementation [" + factory + "]"));
                factory.setValidating(this.validating);
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                docBuilder.setErrorHandler(new BeansErrorHandler());
                docBuilder.setEntityResolver(this.entityResolver != null ? this.entityResolver : new BeansDtdResolver());
                is = resource.getInputStream();
                Document doc = docBuilder.parse(is);
                this.registerBeanDefinitions(doc, resource);
            }
            catch (ParserConfigurationException ex) {
                throw new BeanDefinitionStoreException("Parser configuration exception parsing XML from " + resource, ex);
            }
            catch (SAXParseException ex) {
                throw new BeanDefinitionStoreException("Line " + ex.getLineNumber() + " in XML document from " + resource + " is invalid", ex);
            }
            catch (SAXException ex) {
                throw new BeanDefinitionStoreException("XML document from " + resource + " is invalid", ex);
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("IOException parsing XML document from " + resource, ex);
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new FatalBeanException("IOException closing stream for XML document from " + resource, ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new FatalBeanException("IOException closing stream for XML document from " + resource, ex);
        }
        if (is == null) return;
        is.close();
    }

    public void registerBeanDefinitions(Document doc, Resource resource) throws BeansException {
        XmlBeanDefinitionParser parser = (XmlBeanDefinitionParser)BeanUtils.instantiateClass(this.parserClass);
        parser.registerBeanDefinitions(this.getBeanFactory(), this.getBeanClassLoader(), doc, resource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BeansErrorHandler
    implements ErrorHandler {
        private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$xml$XmlBeanFactory == null ? (class$org$springframework$beans$factory$xml$XmlBeanFactory = XmlBeanDefinitionReader.class$("org.springframework.beans.factory.xml.XmlBeanFactory")) : class$org$springframework$beans$factory$xml$XmlBeanFactory));

        private BeansErrorHandler() {
        }

        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void warning(SAXParseException ex) throws SAXException {
            logger.warn((Object)("Ignored XML validation warning: " + ex));
        }
    }
}

