/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.RuntimeBeanReference;
import org.springframework.core.io.Resource;

public class PropertiesBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    public static final String TRUE_VALUE = "true";
    public static final String SEPARATOR = ".";
    public static final String CLASS_KEY = "class";
    public static final String SINGLETON_KEY = "(singleton)";
    public static final String LAZY_INIT_KEY = "(lazy-init)";
    public static final String PARENT_KEY = "parent";
    public static final String REF_SUFFIX = "(ref)";
    public static final String REF_PREFIX = "*";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String defaultParentBean;

    public PropertiesBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
    }

    public void setDefaultParentBean(String defaultParentBean) {
        this.defaultParentBean = defaultParentBean;
    }

    public String getDefaultParentBean() {
        return this.defaultParentBean;
    }

    public int loadBeanDefinitions(Resource resource) {
        return this.loadBeanDefinitions(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBeanDefinitions(Resource resource, String prefix) {
        Properties props = new Properties();
        try {
            InputStream is = resource.getInputStream();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            return this.registerBeanDefinitions(props, prefix);
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("IOException parsing properties from " + resource, ex);
        }
    }

    public int registerBeanDefinitions(ResourceBundle rb) throws BeanDefinitionStoreException {
        return this.registerBeanDefinitions(rb, null);
    }

    public int registerBeanDefinitions(ResourceBundle rb, String prefix) throws BeanDefinitionStoreException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            m.put(key, rb.getObject(key));
        }
        return this.registerBeanDefinitions(m, prefix);
    }

    public int registerBeanDefinitions(Map m) throws BeansException {
        return this.registerBeanDefinitions(m, null);
    }

    public int registerBeanDefinitions(Map m, String prefix) throws BeansException {
        if (prefix == null) {
            prefix = "";
        }
        int beanCount = 0;
        Set keys = m.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(prefix)) continue;
            String nameAndProperty = key.substring(prefix.length());
            int sepIndx = nameAndProperty.indexOf(SEPARATOR);
            if (sepIndx != -1) {
                String beanName = nameAndProperty.substring(0, sepIndx);
                this.logger.debug((Object)("Found bean name '" + beanName + "'"));
                if (this.getBeanFactory().containsBeanDefinition(beanName)) continue;
                this.registerBeanDefinition(beanName, m, prefix + beanName);
                ++beanCount;
                continue;
            }
            this.logger.debug((Object)("Invalid bean name and property [" + nameAndProperty + "]"));
        }
        return beanCount;
    }

    private void registerBeanDefinition(String beanName, Map m, String prefix) throws BeansException {
        String className = null;
        String parent = null;
        boolean singleton = true;
        boolean lazyInit = false;
        MutablePropertyValues pvs = new MutablePropertyValues();
        Set keys = m.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String sval;
            Object val;
            String key = (String)itr.next();
            if (!key.startsWith(prefix + SEPARATOR)) continue;
            String property = key.substring(prefix.length() + SEPARATOR.length());
            if (property.equals(CLASS_KEY)) {
                className = (String)m.get(key);
                continue;
            }
            if (property.equals(SINGLETON_KEY)) {
                val = (String)m.get(key);
                singleton = val == null || ((String)val).equals(TRUE_VALUE);
                continue;
            }
            if (property.equals(LAZY_INIT_KEY)) {
                val = (String)m.get(key);
                lazyInit = ((String)val).equals(TRUE_VALUE);
                continue;
            }
            if (property.equals(PARENT_KEY)) {
                parent = (String)m.get(key);
                continue;
            }
            if (property.endsWith(REF_SUFFIX)) {
                property = property.substring(0, property.length() - REF_SUFFIX.length());
                String ref = (String)m.get(key);
                RuntimeBeanReference val2 = new RuntimeBeanReference(ref);
                pvs.addPropertyValue(new PropertyValue(property, val2));
                continue;
            }
            val = m.get(key);
            if (val instanceof String && (sval = val).startsWith(REF_PREFIX)) {
                String targetName = ((String)val).substring(1);
                val = sval.startsWith("**") ? targetName : new RuntimeBeanReference(targetName);
            }
            pvs.addPropertyValue(new PropertyValue(property, val));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)pvs.toString());
        }
        if (parent == null) {
            parent = this.defaultParentBean;
        }
        if (className == null && parent == null) {
            throw new FatalBeanException("Invalid bean definition. class or parent must be supplied for bean with name '" + beanName + "'");
        }
        try {
            AbstractBeanDefinition beanDefinition = null;
            if (className != null) {
                Class<?> clazz = Class.forName(className, true, this.getBeanClassLoader());
                beanDefinition = new RootBeanDefinition(clazz, pvs);
            } else {
                beanDefinition = new ChildBeanDefinition(parent, pvs);
            }
            beanDefinition.setSingleton(singleton);
            beanDefinition.setLazyInit(lazyInit);
            this.getBeanFactory().registerBeanDefinition(beanName, beanDefinition);
        }
        catch (ClassNotFoundException ex) {
            throw new FatalBeanException("Cannot find class [" + className + "] for bean with name '" + beanName + "'", ex);
        }
    }
}

