/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.Serializable;
import org.springframework.beans.SortDefinition;

public class MutableSortDefinition
implements SortDefinition,
Serializable {
    private String property = "";
    private boolean ignoreCase = true;
    private boolean ascending = true;
    private boolean toggleAscendingOnProperty = false;

    public MutableSortDefinition() {
    }

    public MutableSortDefinition(SortDefinition source) {
        this.property = source.getProperty();
        this.ignoreCase = source.isIgnoreCase();
        this.ascending = source.isAscending();
    }

    public MutableSortDefinition(String property, boolean ignoreCase, boolean ascending) {
        this.property = property;
        this.ignoreCase = ignoreCase;
        this.ascending = ascending;
    }

    public MutableSortDefinition(boolean toggleAscendingOnSameProperty) {
        this.toggleAscendingOnProperty = toggleAscendingOnSameProperty;
    }

    public void setProperty(String property) {
        if (property == null || "".equals(property)) {
            this.property = "";
        } else {
            if (this.toggleAscendingOnProperty) {
                this.ascending = property.equals(this.property) ? !this.ascending : true;
            }
            this.property = property;
        }
    }

    public String getProperty() {
        return this.property;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setToggleAscendingOnProperty(boolean toggleAscendingOnProperty) {
        this.toggleAscendingOnProperty = toggleAscendingOnProperty;
    }

    public boolean isToggleAscendingOnProperty() {
        return this.toggleAscendingOnProperty;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SortDefinition)) {
            return false;
        }
        SortDefinition sd = (SortDefinition)obj;
        return this.getProperty().equals(sd.getProperty()) && this.isAscending() == sd.isAscending() && this.isIgnoreCase() == sd.isIgnoreCase();
    }

    public int hashCode() {
        int result = this.property.hashCode();
        result = 29 * result + (this.ignoreCase ? 1 : 0);
        result = 29 * result + (this.ascending ? 1 : 0);
        return result;
    }
}

