/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

public abstract class AutowireUtils {
    public static void sortConstructors(Constructor[] constructors) {
        Arrays.sort(constructors, new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean p2;
                Constructor c1 = (Constructor)o1;
                Constructor c2 = (Constructor)o2;
                boolean p1 = Modifier.isPublic(c1.getModifiers());
                if (p1 != (p2 = Modifier.isPublic(c2.getModifiers()))) {
                    return p1 ? -1 : 1;
                }
                int c1pl = c1.getParameterTypes().length;
                int c2pl = c2.getParameterTypes().length;
                return new Integer(c1pl).compareTo(new Integer(c2pl)) * -1;
            }
        });
    }

    public static int getTypeDifferenceWeight(Class[] argTypes, Object[] args) {
        int result = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            if (!BeanUtils.isAssignable(argTypes[i], args[i])) {
                return Integer.MAX_VALUE;
            }
            if (args[i] == null) continue;
            Class<?> superClass = args[i].getClass().getSuperclass();
            while (superClass != null) {
                if (BeanUtils.isAssignable(argTypes[i], superClass)) {
                    ++result;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
        }
        return result;
    }

    public static boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        return pd.getWriteMethod().getDeclaringClass().getName().indexOf("$$") != -1;
    }

    public static boolean isSetterDefinedInInterface(PropertyDescriptor pd, Set interfaces) {
        Method setter = pd.getWriteMethod();
        if (setter != null) {
            Class<?> targetClass = setter.getDeclaringClass();
            Iterator it = interfaces.iterator();
            while (it.hasNext()) {
                Class ifc = (Class)it.next();
                if (!ifc.isAssignableFrom(targetClass) || !ClassUtils.hasMethod((Class)ifc, (String)setter.getName(), (Class[])setter.getParameterTypes())) continue;
                return true;
            }
        }
        return false;
    }
}

