/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.access;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SingletonBeanFactoryLocator
implements BeanFactoryLocator {
    public static final String BEANS_REFS_XML_NAME = "classpath*:beanRefFactory.xml";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator == null ? (class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator = SingletonBeanFactoryLocator.class$("org.springframework.beans.factory.access.SingletonBeanFactoryLocator")) : class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator));
    private static Map instances = new HashMap();
    private Map bfgInstancesByKey = new HashMap();
    private Map bfgInstancesByObj = new HashMap();
    private String resourceName;
    static /* synthetic */ Class class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator;

    public static BeanFactoryLocator getInstance() throws FatalBeanException {
        return SingletonBeanFactoryLocator.getInstance(BEANS_REFS_XML_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String selector) throws FatalBeanException {
        if (selector.indexOf(58) == -1) {
            selector = "classpath*:" + selector;
        }
        Map map = instances;
        synchronized (map) {
            BeanFactoryLocator bfl = (BeanFactoryLocator)instances.get(selector);
            if (bfl == null) {
                bfl = new SingletonBeanFactoryLocator(selector);
                instances.put(selector, bfl);
            }
            return bfl;
        }
    }

    protected SingletonBeanFactoryLocator() {
        this.resourceName = BEANS_REFS_XML_NAME;
    }

    protected SingletonBeanFactoryLocator(String resourceName) {
        this.resourceName = resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanFactoryReference useBeanFactory(String factoryKey) throws BeansException {
        Map map = this.bfgInstancesByKey;
        synchronized (map) {
            Object bean;
            BeanFactory groupContext;
            BeanFactoryGroup bfg = (BeanFactoryGroup)this.bfgInstancesByKey.get(this.resourceName);
            if (bfg != null) {
                bfg.refCount++;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Factory group with resource name [" + this.resourceName + "] requested. Creating new instance."));
                }
                groupContext = this.createDefinition(this.resourceName, factoryKey);
                bfg = new BeanFactoryGroup();
                bfg.definition = groupContext;
                bfg.refCount = 1;
                this.bfgInstancesByKey.put(this.resourceName, bfg);
                this.bfgInstancesByObj.put(groupContext, bfg);
                try {
                    this.initializeDefinition(groupContext);
                }
                catch (BeansException e) {
                    throw new FatalBeanException("Unable to initialize group definition. Group resource name [" + this.resourceName + "], factory key [" + factoryKey + "]", (Throwable)((Object)e));
                }
            }
            groupContext = bfg.definition;
            String lookupId = factoryKey;
            try {
                bean = groupContext.getBean(lookupId);
            }
            catch (BeansException ex) {
                throw new FatalBeanException("Unable to return specified BeanFactory instance: factory key [" + factoryKey + "], from group with resource name [" + this.resourceName + "]", (Throwable)((Object)ex));
            }
            if (bean instanceof String) {
                lookupId = (String)bean;
                try {
                    bean = groupContext.getBean(lookupId);
                }
                catch (BeansException ex) {
                    throw new FatalBeanException("Unable to return specified BeanFactory instance: lookup ID [" + lookupId + "], factory key [" + factoryKey + "], from group with resource name [" + this.resourceName + "]", (Throwable)((Object)ex));
                }
            }
            if (!(bean instanceof BeanFactory)) {
                throw new FatalBeanException("Returned bean is not BeanFactory or its subclass. lookup ID [" + lookupId + "], factory key [" + factoryKey + "], from group with resource name [" + this.resourceName + "]. Returned object class is [" + bean.getClass().getName() + "]");
            }
            final BeanFactory beanFactory = (BeanFactory)bean;
            return new BeanFactoryReference(){
                BeanFactory groupContextRef;
                {
                    this.groupContextRef = groupContext;
                }

                public BeanFactory getFactory() {
                    return beanFactory;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void release() throws FatalBeanException {
                    Map map = SingletonBeanFactoryLocator.this.bfgInstancesByKey;
                    synchronized (map) {
                        BeanFactory savedRef = this.groupContextRef;
                        if (savedRef != null) {
                            this.groupContextRef = null;
                            BeanFactoryGroup bfg = (BeanFactoryGroup)SingletonBeanFactoryLocator.this.bfgInstancesByObj.get(savedRef);
                            if (bfg != null) {
                                bfg.refCount--;
                                if (bfg.refCount == 0) {
                                    SingletonBeanFactoryLocator.this.destroyDefinition(savedRef, SingletonBeanFactoryLocator.this.resourceName);
                                    SingletonBeanFactoryLocator.this.bfgInstancesByKey.remove(SingletonBeanFactoryLocator.this.resourceName);
                                    SingletonBeanFactoryLocator.this.bfgInstancesByObj.remove(savedRef);
                                }
                            } else {
                                logger.warn((Object)("Tried to release a SingletonBeanFactoryLocator (or subclass) group definition more times than it has actually been used. Resource name [" + SingletonBeanFactoryLocator.this.resourceName + "]"));
                            }
                        }
                    }
                }
            };
        }
    }

    protected BeanFactory createDefinition(String resourceName, String factoryKey) throws BeansException {
        Resource[] configResources;
        DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(factory);
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        try {
            configResources = resourcePatternResolver.getResources(resourceName);
        }
        catch (IOException e) {
            throw new BeanDefinitionStoreException("Error accessing bean definition resource", e);
        }
        if (configResources.length == 0) {
            throw new FatalBeanException("Unable to find resource for specified definition. Group resource name [" + this.resourceName + "], factory key [" + factoryKey + "]");
        }
        try {
            for (int j = 0; j < configResources.length; ++j) {
                reader.loadBeanDefinitions(configResources[j]);
            }
        }
        catch (BeansException e) {
            throw new FatalBeanException("Unable to load group definition. Group resource name [" + this.resourceName + "], factory key [" + factoryKey + "]", (Throwable)((Object)e));
        }
        return factory;
    }

    protected void initializeDefinition(BeanFactory groupDef) throws BeansException {
        if (groupDef instanceof DefaultListableBeanFactory) {
            ((DefaultListableBeanFactory)groupDef).preInstantiateSingletons();
        }
    }

    protected void destroyDefinition(BeanFactory groupDef, String resourceName) throws BeansException {
        if (groupDef instanceof ConfigurableBeanFactory) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Factory group with resource name '" + resourceName + "' being released, as there are no more references to it."));
            }
            ((ConfigurableBeanFactory)groupDef).destroySingletons();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BeanFactoryGroup {
        private BeanFactory definition;
        private int refCount = 0;

        private BeanFactoryGroup() {
        }
    }
}

