/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.access;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.access.BootstrapException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;

public class BeanFactoryBootstrap {
    public static final String BEAN_FACTORY_BEAN_NAME = "bootstrapBeanFactory";
    private static BeanFactoryBootstrap instance;
    private static BeansException startupException;
    private BeanFactory bootstrapFactory;

    private static void initializeSingleton() {
        try {
            instance = new BeanFactoryBootstrap();
        }
        catch (BeansException ex) {
            startupException = ex;
        }
    }

    public static BeanFactoryBootstrap getInstance() throws BeansException {
        if (startupException != null) {
            throw startupException;
        }
        if (instance == null) {
            throw new BootstrapException("Anomaly: instance and exception null", null);
        }
        return instance;
    }

    protected static void reinitialize() {
        instance = null;
        startupException = null;
        BeanFactoryBootstrap.initializeSingleton();
    }

    private BeanFactoryBootstrap() throws BeansException {
        DefaultListableBeanFactory startupFactory = new DefaultListableBeanFactory();
        PropertiesBeanDefinitionReader propReader = new PropertiesBeanDefinitionReader(startupFactory);
        try {
            propReader.registerBeanDefinitions(System.getProperties());
            this.bootstrapFactory = (BeanFactory)startupFactory.getBean(BEAN_FACTORY_BEAN_NAME);
        }
        catch (ClassCastException ex) {
            throw new BootstrapException("Bootstrap bean factory class does not implement BeanFactory interface", ex);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new BootstrapException("No bean named 'bootstrapBeanFactory' in system properties: [" + startupFactory + "]", null);
        }
        catch (BeansException ex) {
            throw new BootstrapException("Failed to bootstrap bean factory", (Throwable)((Object)ex));
        }
    }

    public BeanFactory getBeanFactory() {
        return this.bootstrapFactory;
    }

    static {
        BeanFactoryBootstrap.initializeSingleton();
    }
}

