/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class PropertiesEditor
extends PropertyEditorSupport {
    private static final String COMMENT_MARKERS = "#!";

    public void setAsText(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("Cannot set Properties to null");
        }
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(s.getBytes()));
            this.dropComments(props);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to read String");
        }
        this.setValue(props);
    }

    private void dropComments(Properties props) {
        Iterator<Object> keys = props.keySet().iterator();
        LinkedList<String> commentKeys = new LinkedList<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.length() <= 0 || COMMENT_MARKERS.indexOf(key.charAt(0)) == -1) continue;
            commentKeys.add(key);
        }
        for (int i = 0; i < commentKeys.size(); ++i) {
            String key = (String)commentKeys.get(i);
            props.remove(key);
        }
    }
}

