/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api.util;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BlackboardMap {
    private final ConcurrentHashMap<Key<Object>, Object> blackboardMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Key<Object>> blackboardKeys = new ConcurrentHashMap();

    public <V> @NonNull Optional<V> get(@NonNull Key<V> key) {
        return Optional.ofNullable(((Key)key).type.cast(this.blackboardMap.get(key)));
    }

    public <V> void put(@NonNull Key<V> key, V value) {
        this.put(this.blackboardMap, key, value);
    }

    public <V> @Nullable V computeIfAbsent(@NonNull Key<V> key, @NonNull Function<? super Key<V>, ? extends V> valueFunction) {
        return this.computeIfAbsent(this.blackboardMap, key, valueFunction);
    }

    private <C1, C2, V> void put(ConcurrentHashMap<C1, C2> map, Key<V> key, V value) {
        map.put(key, value);
    }

    private <C1, C2, V> V computeIfAbsent(ConcurrentHashMap<C1, C2> map, Key<V> key, Function<? super Key<V>, ? extends V> valueFunction) {
        return map.computeIfAbsent(key, valueFunction);
    }

    private ConcurrentHashMap<String, Key<Object>> getKeys() {
        return this.blackboardKeys;
    }

    public static final class Key<T>
    implements Comparable<Key<T>> {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        private final String name;
        private final long identifier;
        private final Class<T> type;

        public static <V> @NonNull Key<V> getOrCreate(@NonNull BlackboardMap owner, @NonNull String name, @NonNull Class<? super V> clazz) {
            Key result = owner.getKeys().computeIfAbsent(name, n -> new Key((String)n, clazz));
            if (result.type != clazz) {
                throw new IllegalArgumentException("Invalid type!");
            }
            return result;
        }

        private Key(String name, Class<T> type) {
            this.type = type;
            this.name = name;
            this.identifier = ID_GENERATOR.getAndIncrement();
        }

        public final @NonNull String getName() {
            return this.name;
        }

        public int hashCode() {
            return (int)(this.identifier ^ this.identifier >>> 32);
        }

        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key that = (Key)other;
            return Objects.equals(this.identifier, that.identifier);
        }

        @Override
        public int compareTo(@NonNull Key<T> other) {
            if (this == other) {
                return 0;
            }
            if (this.identifier < other.identifier) {
                return -1;
            }
            if (this.identifier > other.identifier) {
                return 1;
            }
            throw new RuntimeException("Unable to compare provided key!");
        }
    }
}

