/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api.config;

import java.nio.file.Path;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.loader.ConfigurationLoader;

public final class Configuration<T, N extends ConfigurationNode> {
    private final Key<T> key;
    private final ConfigurationLoader<N> loader;
    private N node;
    private T instance;

    public static <T> @NonNull Key<T> key(@NonNull Class<T> type, @NonNull Path path) {
        return new Key<T>(type, type.getSimpleName(), path);
    }

    public static <T> @NonNull Key<T> key(@NonNull Class<T> type, @NonNull String id, @NonNull Path path) {
        return new Key<T>(type, id, path);
    }

    Configuration(@NonNull Key<T> key, @NonNull ConfigurationLoader<N> loader) {
        this.key = key;
        this.loader = loader;
    }

    public void load() throws ConfigurateException {
        this.node = this.loader.load();
        this.instance = this.node.get(this.key.type());
    }

    public void save() throws ConfigurateException {
        if (this.node == null) {
            this.node = this.loader.createNode();
        }
        if (this.instance != null) {
            this.node.set(this.key.type(), this.instance);
        }
        this.loader.save(this.node);
    }

    public @NonNull Key<T> key() {
        return this.key;
    }

    public @MonotonicNonNull N node() {
        return this.node;
    }

    public @MonotonicNonNull T instance() {
        return this.instance;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.loader, this.node, this.instance);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)other;
        return Objects.equals(this.key, that.key) && Objects.equals(this.loader, that.loader) && Objects.equals(this.node, that.node) && Objects.equals(this.instance, that.instance);
    }

    public String toString() {
        return "Configuration{key=" + this.key + ", loader=" + this.loader + ", node=" + this.node + ", instance=" + this.instance + "}";
    }

    public static final class Key<T> {
        private final Class<T> type;
        private final String id;
        private final Path path;

        Key(@NonNull Class<T> type, @NonNull String id, @NonNull Path path) {
            this.type = type;
            this.id = id;
            this.path = path;
        }

        public @NonNull Class<T> type() {
            return this.type;
        }

        public @NonNull String id() {
            return this.id;
        }

        public @NonNull Path path() {
            return this.path;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.id, this.path);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key that = (Key)other;
            return Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.path, that.path);
        }

        public String toString() {
            return "Configuration.Key{type=" + this.type + ", id=" + this.id + ", path=" + this.path + "}";
        }
    }
}

