/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api.mod;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Objects;
import java.util.jar.Manifest;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ModResource {
    private final String locator;
    private final Path path;
    private final Manifest manifest;
    private FileSystem fileSystem;

    public ModResource(@NonNull String locator, @NonNull Path path, @NonNull Manifest manifest) {
        this.locator = locator;
        this.path = path;
        this.manifest = manifest;
    }

    public final @NonNull String getLocator() {
        return this.locator;
    }

    public final @NonNull Path getPath() {
        return this.path;
    }

    public final @NonNull Manifest getManifest() {
        return this.manifest;
    }

    public final @NonNull FileSystem getFileSystem() {
        if (this.fileSystem == null) {
            try {
                this.fileSystem = FileSystems.newFileSystem(this.getPath(), this.getClass().getClassLoader());
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.fileSystem;
    }

    public final int hashCode() {
        return Objects.hash(this.locator, this.path, this.manifest);
    }

    public final boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModResource)) {
            return false;
        }
        ModResource that = (ModResource)other;
        return Objects.equals(this.locator, that.locator) && Objects.equals(this.path, that.path) && Objects.equals(this.manifest, that.manifest);
    }

    public final @NonNull String toString() {
        return "ModResource{name=" + this.locator + ", path=" + this.path + ", fileSystem=" + this.fileSystem + "}";
    }
}

