/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api;

import com.google.common.reflect.TypeToken;
import java.nio.file.Path;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.ignite.api.util.BlackboardMap;

public final class Blackboard {
    private static final BlackboardMap BLACKBOARD = new BlackboardMap();
    public static final @NonNull BlackboardMap.Key<List<String>> LAUNCH_ARGUMENTS = Blackboard.key("ignite.launch.arguments", new TypeToken<List<String>>(){});
    public static final @NonNull BlackboardMap.Key<String> LAUNCH_SERVICE = Blackboard.key("ignite.launch.service", TypeToken.of(String.class));
    public static final @NonNull BlackboardMap.Key<Path> LAUNCH_JAR = Blackboard.key("ignite.launch.jar", TypeToken.of(Path.class));
    public static final @NonNull BlackboardMap.Key<String> LAUNCH_TARGET = Blackboard.key("ignite.launch.target", TypeToken.of(String.class));
    public static final @NonNull BlackboardMap.Key<Path> MOD_DIRECTORY_PATH = Blackboard.key("ignite.mod.directory", TypeToken.of(Path.class));
    public static final @NonNull BlackboardMap.Key<Path> CONFIG_DIRECTORY_PATH = Blackboard.key("ignite.config.directory", TypeToken.of(Path.class));

    public static <T> @Nullable T getProperty(@NonNull BlackboardMap.Key<T> key) {
        return BLACKBOARD.get(key).orElse(null);
    }

    public static <T> @NonNull T getProperty(@NonNull BlackboardMap.Key<T> key, @NonNull T defaultValue) {
        return BLACKBOARD.get(key).orElse(defaultValue);
    }

    public static <T> void putProperty(@NonNull BlackboardMap.Key<T> key, @NonNull T value) {
        BLACKBOARD.put(key, value);
    }

    public static <T> void computeProperty(@NonNull BlackboardMap.Key<T> key, @Nullable T value) {
        BLACKBOARD.computeIfAbsent(key, k -> value);
    }

    public static <T> @NonNull BlackboardMap.Key<T> key(@NonNull String key, @NonNull TypeToken<T> type) {
        return BlackboardMap.Key.getOrCreate(BLACKBOARD, key, type.getRawType());
    }
}

