/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MD2Serializer;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=MD2Serializer.class)
public final class MD2
implements Comparable<MD2> {
    @NotNull
    public static final MD2 ZERO = new MD2(0, 0, 0, 0);
    public static final int SIZE_IN_BYTES = 16;
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;

    @NotNull
    private static MessageDigest newDigest() {
        return SharedUtil.messageDigest("MD2");
    }

    MD2(int i0, int i1, int i2, int i3) {
        this.i0 = i0;
        this.i1 = i1;
        this.i2 = i2;
        this.i3 = i3;
    }

    public MD2(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
    }

    public MD2(byte @NotNull [] arr) {
        this(MD2.checkHashBytes(arr), 0);
    }

    public MD2(@NotNull String hex) {
        this(HexFormat.of().parseHex(MD2.checkHashHex(hex)));
    }

    private static String checkHashHex(String s) {
        if (s.length() != 32) {
            throw new IllegalArgumentException("Expected a 32-character hexadecimal MD2 hash, but got " + s.length() + " characters.");
        }
        return s;
    }

    private static byte[] checkHashBytes(byte[] b) {
        if (b.length != 16) {
            throw new IllegalArgumentException("Expected a 16-byte MD2 hash, but got " + b.length + " bytes.");
        }
        return b;
    }

    @NotNull
    public static MessageDigest getMessageDigest() {
        return MD2.newDigest();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[16], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MD2 t = (MD2)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3;
    }

    public int hashCode() {
        int r = this.i0;
        r = 31 * r + this.i1;
        r = 31 * r + this.i2;
        r = 31 * r + this.i3;
        return r;
    }

    @NotNull
    public static MD2 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(MD2.newDigest(), inputStream, MD2::new);
    }

    @NotNull
    public static MD2 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(MD2.newDigest(), channel, MD2::new);
    }

    @NotNull
    public static MD2 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(MD2.newDigest(), path, MD2::new);
    }

    @NotNull
    public static MD2 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(MD2.newDigest(), data, off, len, MD2::new);
    }

    @NotNull
    public static MD2 of(byte @NotNull [] data) {
        return MD2.of(data, 0, data.length);
    }

    @NotNull
    public static MessageDigestInterceptedInputStream<MD2> intercept(@NotNull InputStream inputStream) {
        return SharedUtil.forInterceptedInputStream(MD2.newDigest(), inputStream, MD2::new);
    }

    @Override
    public int compareTo(@NotNull MD2 o) {
        int r = Integer.compareUnsigned(this.i0, o.i0);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i1, o.i1);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i2, o.i2);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i3, o.i3);
        if (r != 0) {
            return r;
        }
        return 0;
    }
}

