/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;
import space.iseki.hashutil.SM3Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=SM3Serializer.class)
public final class SM3
implements Comparable<SM3> {
    @NotNull
    public static final SM3 ZERO = new SM3(0, 0, 0, 0, 0, 0, 0, 0);
    public static final int SIZE_IN_BYTES = 32;
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;
    private final int i4;
    private final int i5;
    private final int i6;
    private final int i7;

    @NotNull
    private static MessageDigest newDigest() {
        return SharedUtil.messageDigest("SM3");
    }

    SM3(int i0, int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        this.i0 = i0;
        this.i1 = i1;
        this.i2 = i2;
        this.i3 = i3;
        this.i4 = i4;
        this.i5 = i5;
        this.i6 = i6;
        this.i7 = i7;
    }

    public SM3(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
        this.i4 = SharedUtil.AVH.get(arr, off + 16);
        this.i5 = SharedUtil.AVH.get(arr, off + 20);
        this.i6 = SharedUtil.AVH.get(arr, off + 24);
        this.i7 = SharedUtil.AVH.get(arr, off + 28);
    }

    public SM3(byte @NotNull [] arr) {
        this(SM3.checkHashBytes(arr), 0);
    }

    public SM3(@NotNull String hex) {
        this(HexFormat.of().parseHex(SM3.checkHashHex(hex)), 0);
    }

    private static String checkHashHex(String s) {
        if (s.length() != 64) {
            throw new IllegalArgumentException("Expected a 64-character hexadecimal SM3 hash, but got " + s.length() + " characters.");
        }
        return s;
    }

    private static byte[] checkHashBytes(byte[] b) {
        if (b.length != 32) {
            throw new IllegalArgumentException("Expected a 32-byte SM3 hash, but got " + b.length + " bytes.");
        }
        return b;
    }

    @NotNull
    public static MessageDigest getMessageDigest() {
        return SM3.newDigest();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        SharedUtil.AVH.set(arr, off + 16, this.i4);
        SharedUtil.AVH.set(arr, off + 20, this.i5);
        SharedUtil.AVH.set(arr, off + 24, this.i6);
        SharedUtil.AVH.set(arr, off + 28, this.i7);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[32], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SM3 t = (SM3)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3 && this.i4 == t.i4 && this.i5 == t.i5 && this.i6 == t.i6 && this.i7 == t.i7;
    }

    public int hashCode() {
        int r = this.i0;
        r = 31 * r + this.i1;
        r = 31 * r + this.i2;
        r = 31 * r + this.i3;
        r = 31 * r + this.i4;
        r = 31 * r + this.i5;
        r = 31 * r + this.i6;
        r = 31 * r + this.i7;
        return r;
    }

    @NotNull
    public static SM3 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(SM3.newDigest(), inputStream, SM3::new);
    }

    @NotNull
    public static SM3 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(SM3.newDigest(), channel, SM3::new);
    }

    @NotNull
    public static SM3 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(SM3.newDigest(), path, SM3::new);
    }

    @NotNull
    public static SM3 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(SM3.newDigest(), data, off, len, SM3::new);
    }

    @NotNull
    public static SM3 of(byte @NotNull [] data) {
        return SM3.of(data, 0, data.length);
    }

    @NotNull
    public static MessageDigestInterceptedInputStream<SM3> intercept(@NotNull InputStream inputStream) {
        return SharedUtil.forInterceptedInputStream(SM3.newDigest(), inputStream, SM3::new);
    }

    @Override
    public int compareTo(@NotNull SM3 o) {
        int r = Integer.compareUnsigned(this.i0, o.i0);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i1, o.i1);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i2, o.i2);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i3, o.i3);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i4, o.i4);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i5, o.i5);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i6, o.i6);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i7, o.i7);
        if (r != 0) {
            return r;
        }
        return 0;
    }

    @NotNull
    public SM3 xor(@NotNull SM3 o) {
        return new SM3(this.i0 ^ o.i0, this.i1 ^ o.i1, this.i2 ^ o.i2, this.i3 ^ o.i3, this.i4 ^ o.i4, this.i5 ^ o.i5, this.i6 ^ o.i6, this.i7 ^ o.i7);
    }

    @NotNull
    public SM3 and(@NotNull SM3 o) {
        return new SM3(this.i0 & o.i0, this.i1 & o.i1, this.i2 & o.i2, this.i3 & o.i3, this.i4 & o.i4, this.i5 & o.i5, this.i6 & o.i6, this.i7 & o.i7);
    }

    @NotNull
    public SM3 or(@NotNull SM3 o) {
        return new SM3(this.i0 | o.i0, this.i1 | o.i1, this.i2 | o.i2, this.i3 | o.i3, this.i4 | o.i4, this.i5 | o.i5, this.i6 | o.i6, this.i7 | o.i7);
    }

    @NotNull
    public SM3 inv() {
        return new SM3(~this.i0, ~this.i1, ~this.i2, ~this.i3, ~this.i4, ~this.i5, ~this.i6, ~this.i7);
    }

    public int bitCount() {
        return Integer.bitCount(this.i0) + Integer.bitCount(this.i1) + Integer.bitCount(this.i2) + Integer.bitCount(this.i3) + Integer.bitCount(this.i4) + Integer.bitCount(this.i5) + Integer.bitCount(this.i6) + Integer.bitCount(this.i7);
    }
}

