/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;
import space.iseki.hashutil.SHA1Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=SHA1Serializer.class)
public final class SHA1
implements Comparable<SHA1> {
    @NotNull
    public static final SHA1 ZERO = new SHA1(0, 0, 0, 0, 0);
    public static final int SIZE_IN_BYTES = 20;
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;
    private final int i4;

    @NotNull
    private static MessageDigest newDigest() {
        return SharedUtil.messageDigest("SHA1");
    }

    SHA1(int i0, int i1, int i2, int i3, int i4) {
        this.i0 = i0;
        this.i1 = i1;
        this.i2 = i2;
        this.i3 = i3;
        this.i4 = i4;
    }

    public SHA1(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
        this.i4 = SharedUtil.AVH.get(arr, off + 16);
    }

    public SHA1(byte @NotNull [] arr) {
        this(SHA1.checkHashBytes(arr), 0);
    }

    public SHA1(@NotNull String hex) {
        this(HexFormat.of().parseHex(SHA1.checkHashHex(hex)), 0);
    }

    private static String checkHashHex(String s) {
        if (s.length() != 40) {
            throw new IllegalArgumentException("Expected a 40-character hexadecimal SHA1 hash, but got " + s.length() + " characters.");
        }
        return s;
    }

    private static byte[] checkHashBytes(byte[] b) {
        if (b.length != 20) {
            throw new IllegalArgumentException("Expected a 20-byte SHA1 hash, but got " + b.length + " bytes.");
        }
        return b;
    }

    @NotNull
    public static MessageDigest getMessageDigest() {
        return SHA1.newDigest();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        SharedUtil.AVH.set(arr, off + 16, this.i4);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[20], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA1 t = (SHA1)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3 && this.i4 == t.i4;
    }

    public int hashCode() {
        int r = this.i0;
        r = 31 * r + this.i1;
        r = 31 * r + this.i2;
        r = 31 * r + this.i3;
        r = 31 * r + this.i4;
        return r;
    }

    @NotNull
    public static SHA1 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(SHA1.newDigest(), inputStream, SHA1::new);
    }

    @NotNull
    public static SHA1 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(SHA1.newDigest(), channel, SHA1::new);
    }

    @NotNull
    public static SHA1 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(SHA1.newDigest(), path, SHA1::new);
    }

    @NotNull
    public static SHA1 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(SHA1.newDigest(), data, off, len, SHA1::new);
    }

    @NotNull
    public static SHA1 of(byte @NotNull [] data) {
        return SHA1.of(data, 0, data.length);
    }

    @NotNull
    public static MessageDigestInterceptedInputStream<SHA1> intercept(@NotNull InputStream inputStream) {
        return SharedUtil.forInterceptedInputStream(SHA1.newDigest(), inputStream, SHA1::new);
    }

    @Override
    public int compareTo(@NotNull SHA1 o) {
        int r = Integer.compareUnsigned(this.i0, o.i0);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i1, o.i1);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i2, o.i2);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i3, o.i3);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i4, o.i4);
        if (r != 0) {
            return r;
        }
        return 0;
    }

    @NotNull
    public SHA1 xor(@NotNull SHA1 o) {
        return new SHA1(this.i0 ^ o.i0, this.i1 ^ o.i1, this.i2 ^ o.i2, this.i3 ^ o.i3, this.i4 ^ o.i4);
    }

    @NotNull
    public SHA1 and(@NotNull SHA1 o) {
        return new SHA1(this.i0 & o.i0, this.i1 & o.i1, this.i2 & o.i2, this.i3 & o.i3, this.i4 & o.i4);
    }

    @NotNull
    public SHA1 or(@NotNull SHA1 o) {
        return new SHA1(this.i0 | o.i0, this.i1 | o.i1, this.i2 | o.i2, this.i3 | o.i3, this.i4 | o.i4);
    }

    @NotNull
    public SHA1 inv() {
        return new SHA1(~this.i0, ~this.i1, ~this.i2, ~this.i3, ~this.i4);
    }

    public int bitCount() {
        return Integer.bitCount(this.i0) + Integer.bitCount(this.i1) + Integer.bitCount(this.i2) + Integer.bitCount(this.i3) + Integer.bitCount(this.i4);
    }
}

