/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;

class SharedUtil {
    @NotNull
    public static final String BUFFER_PROPERTY_NAME = "space.iseki.hashutil.buffer.size";
    @NotNull
    public static final String USE_THREAD_LOCAL_PROPERTY_NAME = "space.iseki.hashutil.threadlocal";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int BUFFER_SIZE;
    public static final boolean USE_THREAD_LOCAL;
    private static final ThreadLocal<WeakReference<ByteBuffer>> bufferThreadLocal;
    static VarHandle AVH;

    SharedUtil() {
    }

    @Nullable
    static ThreadLocal<MessageDigest> getThreadLocal(String name) {
        return USE_THREAD_LOCAL ? ThreadLocal.withInitial(() -> SharedUtil.messageDigest(name)) : null;
    }

    static MessageDigest messageDigest(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> T forInputStream(MessageDigest digest, InputStream inputStream, Function<byte[], T> call) throws IOException {
        byte[] buf = SharedUtil.getSharedBuffer().array();
        try {
            int n22;
            while ((n22 = inputStream.read(buf)) != -1) {
                digest.update(buf, 0, n22);
            }
            T n22 = SharedUtil.handleDigest(buf, digest, call);
            return n22;
        }
        catch (Throwable th) {
            digest.reset();
            throw th;
        }
        finally {
            Arrays.fill(buf, (byte)0);
        }
    }

    static <T> T forReadableChannel(MessageDigest digest, ReadableByteChannel channel, Function<byte[], T> call) throws IOException {
        ByteBuffer buf = SharedUtil.getSharedBuffer();
        byte[] arr = buf.array();
        try {
            int n22;
            while ((n22 = channel.read(buf)) != -1) {
                buf.flip();
                digest.update(buf);
                buf.clear();
            }
            T n22 = SharedUtil.handleDigest(arr, digest, call);
            return n22;
        }
        catch (Throwable th) {
            digest.reset();
            throw th;
        }
        finally {
            buf.clear();
            Arrays.fill(arr, (byte)0);
        }
    }

    static <T> T forPath(MessageDigest digest, Path path, Function<byte[], T> call) throws IOException {
        SeekableByteChannel ch = Files.newByteChannel(path, StandardOpenOption.READ);
        IOException th = null;
        try {
            T t = SharedUtil.forReadableChannel(digest, ch, call);
            return t;
        }
        catch (IOException e) {
            th = e;
            throw th;
        }
        finally {
            try {
                ch.close();
            }
            catch (IOException e) {
                if (th == null) {
                    throw e;
                }
                th.addSuppressed(e);
            }
        }
    }

    static <T> T forBytes(MessageDigest digest, byte[] data, int off, int len, Function<byte[], T> call) {
        try {
            digest.update(data, off, len);
            return call.apply(digest.digest());
        }
        catch (Throwable throwable) {
            digest.reset();
            throw throwable;
        }
    }

    private static <T> T handleDigest(byte[] arr, MessageDigest digest, Function<byte[], T> call) {
        try {
            digest.digest(arr, 0, digest.getDigestLength());
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
        return call.apply(arr);
    }

    static <T> MessageDigestInterceptedInputStream<T> forInterceptedInputStream(MessageDigest digest, InputStream inputStream, Function<byte[], T> call) {
        return new MessageDigestInterceptedInputStream<T>(digest, call, inputStream);
    }

    @NotNull
    private static ByteBuffer getSharedBuffer() {
        ByteBuffer r;
        WeakReference<ByteBuffer> ref = bufferThreadLocal.get();
        ByteBuffer byteBuffer = r = ref != null ? (ByteBuffer)ref.get() : null;
        if (r == null) {
            r = ByteBuffer.allocate(BUFFER_SIZE);
            bufferThreadLocal.set(new WeakReference<ByteBuffer>(r));
        }
        return r;
    }

    static {
        bufferThreadLocal = new ThreadLocal();
        AVH = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN).withInvokeExactBehavior();
        String p = System.getProperty(BUFFER_PROPERTY_NAME);
        BUFFER_SIZE = p == null || p.isBlank() ? 8192 : Integer.parseInt(p);
        USE_THREAD_LOCAL = Boolean.parseBoolean(System.getProperty(USE_THREAD_LOCAL_PROPERTY_NAME, "true"));
    }
}

