/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;
import space.iseki.hashutil.SHA224Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=SHA224Serializer.class)
public final class SHA224
implements Comparable<SHA224> {
    private static final ThreadLocal<MessageDigest> threadLocal = ThreadLocal.withInitial(() -> SharedUtil.messageDigest("SHA224"));
    @NotNull
    public static final SHA224 ZERO = new SHA224(0, 0, 0, 0, 0, 0, 0);
    public static final int SIZE_IN_BYTES = 28;
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;
    private final int i4;
    private final int i5;
    private final int i6;

    @NotNull
    private static MessageDigest newDigest() {
        return SharedUtil.messageDigest("SHA224");
    }

    SHA224(int i0, int i1, int i2, int i3, int i4, int i5, int i6) {
        this.i0 = i0;
        this.i1 = i1;
        this.i2 = i2;
        this.i3 = i3;
        this.i4 = i4;
        this.i5 = i5;
        this.i6 = i6;
    }

    public SHA224(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
        this.i4 = SharedUtil.AVH.get(arr, off + 16);
        this.i5 = SharedUtil.AVH.get(arr, off + 20);
        this.i6 = SharedUtil.AVH.get(arr, off + 24);
    }

    public SHA224(byte @NotNull [] arr) {
        this(arr, 0);
    }

    public SHA224(@NotNull String hex) {
        this(HexFormat.of().parseHex(hex));
    }

    @NotNull
    static MessageDigest getThreadLocalDigest() {
        return threadLocal.get();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        SharedUtil.AVH.set(arr, off + 16, this.i4);
        SharedUtil.AVH.set(arr, off + 20, this.i5);
        SharedUtil.AVH.set(arr, off + 24, this.i6);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[28], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA224 t = (SHA224)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3 && this.i4 == t.i4 && this.i5 == t.i5 && this.i6 == t.i6;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3, this.i4, this.i5, this.i6);
    }

    @NotNull
    public static SHA224 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(SHA224.getThreadLocalDigest(), inputStream, SHA224::new);
    }

    @NotNull
    public static SHA224 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(SHA224.getThreadLocalDigest(), channel, SHA224::new);
    }

    @NotNull
    public static SHA224 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(SHA224.getThreadLocalDigest(), path, SHA224::new);
    }

    @NotNull
    public static SHA224 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(SHA224.getThreadLocalDigest(), data, off, len, SHA224::new);
    }

    @NotNull
    public static SHA224 of(byte @NotNull [] data) {
        return SHA224.of(data, 0, data.length);
    }

    @NotNull
    public static MessageDigestInterceptedInputStream<SHA224> intercept(@NotNull InputStream inputStream) {
        return SharedUtil.forInterceptedInputStream(SHA224.newDigest(), inputStream, SHA224::new);
    }

    @Override
    public int compareTo(@NotNull SHA224 o) {
        int r = Integer.compareUnsigned(this.i0, o.i0);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i1, o.i1);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i2, o.i2);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i3, o.i3);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i4, o.i4);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i5, o.i5);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i6, o.i6);
        if (r != 0) {
            return r;
        }
        return 0;
    }
}

