/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.Algorithms;
import space.iseki.hashutil.Hash;
import space.iseki.hashutil.SHA128Serializer;
import space.iseki.hashutil.Util;

@Serializable(with=SHA128Serializer.class)
public final class SHA128
implements Hash {
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;

    public SHA128(@NotNull byte[] arr, int off) {
        this.i0 = Util.getInt(arr, off + 0);
        this.i1 = Util.getInt(arr, off + 4);
        this.i2 = Util.getInt(arr, off + 8);
        this.i3 = Util.getInt(arr, off + 12);
    }

    public SHA128(@NotNull byte[] arr) {
        this(arr, 0);
    }

    public SHA128(@NotNull String hex) {
        this(Util.decodeHex(hex));
    }

    @Override
    @NotNull
    public byte[] bytes(@NotNull byte[] arr, int off) {
        Util.putInt(arr, off + 0, this.i0);
        Util.putInt(arr, off + 4, this.i1);
        Util.putInt(arr, off + 8, this.i2);
        Util.putInt(arr, off + 12, this.i3);
        return arr;
    }

    @Override
    @NotNull
    public byte[] bytes() {
        return this.bytes(new byte[16], 0);
    }

    @NotNull
    public String toString() {
        return Util.encodeHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA128 t = (SHA128)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3;
    }

    @Override
    @NotNull
    public Algorithms kind() {
        return Algorithms.SHA128;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3);
    }

    @NotNull
    public static MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA128");
    }
}

