/*
 * Decompiled with CFR 0.152.
 */
package solutions.rty.droidrestapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.TextHttpResponseHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import solutions.rty.droidrestapi.RequestResponse;

public final class DroidRestBuilder {
    private final AsyncHttpClient mHttpClient = new AsyncHttpClient();
    private static final int GET = 0;
    private static final int POST = 1;
    private static final int PUT = 2;
    private static final int DELETE = 3;
    private int mRequestMethod = 0;
    private String mPathUrl;
    private Class<?> mTargetClass;
    private TypeReference<?> mTargetTypeReference;
    private RESULT mResultType;
    private StringEntity mBodyRequest;
    private HashMap<String, String> mHeaders;
    private RequestResponse mResponseCallback;
    private TextHttpResponseHandler mResponseHandler = new TextHttpResponseHandler(){

        public void onFailure(int statusCode, Header[] headers, String responseString, Throwable throwable) {
            if (DroidRestBuilder.this.mResponseCallback != null) {
                DroidRestBuilder.this.mResponseCallback.onRequestError(responseString, throwable);
            }
        }

        public void onSuccess(int statusCode, Header[] headers, String responseString) {
            if (DroidRestBuilder.this.mResponseCallback != null) {
                try {
                    Object t = DroidRestBuilder.this.getResultObject(responseString);
                    DroidRestBuilder.this.mResponseCallback.onRequestSuccess(t);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    };

    public DroidRestBuilder() {
    }

    public DroidRestBuilder(DroidRestBuilder builder) {
        this.mPathUrl = builder.mPathUrl;
        this.mRequestMethod = builder.mRequestMethod;
        this.mTargetClass = builder.mTargetClass;
        this.mTargetTypeReference = builder.mTargetTypeReference;
        this.mResultType = builder.mResultType;
        this.mBodyRequest = builder.mBodyRequest;
        this.mHeaders = builder.mHeaders;
    }

    public DroidRestBuilder GET() {
        this.mRequestMethod = 0;
        return new DroidRestBuilder(this);
    }

    public DroidRestBuilder POST(Object requestBody) {
        this.mRequestMethod = 1;
        this.mBodyRequest = this.generateBodyRequest(requestBody);
        return new DroidRestBuilder(this);
    }

    public DroidRestBuilder PUT() {
        this.mRequestMethod = 2;
        return new DroidRestBuilder(this);
    }

    public DroidRestBuilder DELETE() {
        this.mRequestMethod = 3;
        return new DroidRestBuilder(this);
    }

    public DroidRestBuilder url(String pathUrl) {
        this.mPathUrl = pathUrl;
        return new DroidRestBuilder(this);
    }

    public DroidRestBuilder as(Class classTarget) {
        this.mTargetClass = classTarget;
        this.mResultType = RESULT.JSONOBJECT;
        return new DroidRestBuilder(this);
    }

    public DroidRestBuilder as(TypeReference typeToken) {
        this.mTargetTypeReference = typeToken;
        this.mResultType = RESULT.JSONARRAY;
        return new DroidRestBuilder(this);
    }

    private StringEntity generateBodyRequest(Object bodyRequest) {
        StringEntity entity = null;
        try {
            String bodyJson = new ObjectMapper().writeValueAsString(bodyRequest);
            entity = new StringEntity(bodyJson, "UTF-8");
            entity.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
        }
        catch (JsonProcessingException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return entity;
    }

    public void withCallback(RequestResponse callback) {
        if (this.mPathUrl == null) {
            throw new IllegalArgumentException("path url must not be null.");
        }
        this.mResponseCallback = callback;
        this.connect();
    }

    private void connect() {
        switch (this.mRequestMethod) {
            case 0: {
                this.mHttpClient.get(null, this.mPathUrl, (ResponseHandlerInterface)this.mResponseHandler);
                break;
            }
            case 1: {
                this.mHttpClient.post(null, this.mPathUrl, (HttpEntity)this.mBodyRequest, "application/json", (ResponseHandlerInterface)this.mResponseHandler);
                break;
            }
            case 2: {
                this.mHttpClient.put(null, this.mPathUrl, (HttpEntity)this.mBodyRequest, "application/json", (ResponseHandlerInterface)this.mResponseHandler);
                break;
            }
            case 3: {
                this.mHttpClient.delete(null, this.mPathUrl, (ResponseHandlerInterface)this.mResponseHandler);
            }
        }
    }

    private Object getResultObject(String responseString) throws IOException {
        switch (this.mResultType) {
            case JSONOBJECT: {
                return new ObjectMapper().readValue(responseString, this.mTargetClass);
            }
            case JSONARRAY: {
                return new ObjectMapper().readValue(responseString, this.mTargetTypeReference);
            }
        }
        return null;
    }

    public static enum RESULT {
        JSONOBJECT,
        JSONARRAY;

    }
}

