/*
 * Decompiled with CFR 0.152.
 */
package solar.squares.pixelwidth.utils;

import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import solar.squares.pixelwidth.ContextualPixelWidthSource;
import solar.squares.pixelwidth.PixelWidthSource;
import solar.squares.pixelwidth.function.ChatWidthFunction;

public interface CenterAPI {
    public static final int DEFAULT_CHAT_WIDTH = 320;

    public static Component center(@NotNull Component component, float componentWidth, @NotNull TextComponent padding, float paddingWidth, float goalWidth) {
        float widthToPad = (goalWidth - componentWidth) / 2.0f;
        if (paddingWidth > widthToPad) {
            throw new IllegalArgumentException("Padding component is too big to fit at least once on both sides of the center component at least once. Max for given max width(" + goalWidth + ") is " + widthToPad + " Was " + paddingWidth);
        }
        StringBuilder paddingBuilder = new StringBuilder();
        String content = padding.content();
        for (float i = paddingWidth; i < widthToPad; i += paddingWidth) {
            paddingBuilder.append(content);
        }
        TextComponent fullPadding = Component.text((String)paddingBuilder.toString(), (Style)padding.style());
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)fullPadding)).append(component)).append((Component)fullPadding)).build();
    }

    @Deprecated
    public static <CX> Component center(@NotNull Component component, @NotNull ContextualPixelWidthSource<CX> source, @NotNull CX context, @NotNull TextComponent padding, Function<CX, Float> contextToChatWidthFunction) {
        return CenterAPI.center(component, source, context, padding, contextToChatWidthFunction::apply);
    }

    public static <CX> Component center(@NotNull Component component, @NotNull ContextualPixelWidthSource<CX> source, @NotNull CX context, @NotNull TextComponent padding, @NotNull ChatWidthFunction<CX> chatWidthFunction) {
        float componentWidth = source.width(component, context);
        float paddingWidth = source.width((Component)padding, context);
        return CenterAPI.center(component, componentWidth, padding, paddingWidth, chatWidthFunction.chatWidthOf(context));
    }

    public static <CX> Component center(@NotNull Component component, @NotNull ContextualPixelWidthSource<CX> source, @NotNull CX context, @NotNull TextComponent padding, float chatWidth) {
        return CenterAPI.center(component, source, context, padding, cx -> chatWidth);
    }

    public static <CX> Component center(@NotNull Component component, @NotNull ContextualPixelWidthSource<CX> source, @NotNull CX context) {
        return CenterAPI.center(component, source, context, Component.space(), 320.0f);
    }

    public static Component center(@NotNull Component component, @NotNull PixelWidthSource source, @NotNull TextComponent padding, float chatWidth) {
        float componentWidth = source.width(component);
        float paddingWidth = source.width((Component)padding);
        return CenterAPI.center(component, componentWidth, padding, paddingWidth, chatWidth);
    }

    public static Component center(@NotNull Component component, @NotNull PixelWidthSource source, @NotNull TextComponent padding) {
        return CenterAPI.center(component, source, padding, 320.0f);
    }

    public static Component center(@NotNull Component component, @NotNull TextComponent padding) {
        return CenterAPI.center(component, PixelWidthSource.pixelWidth(), padding);
    }

    public static Component center(@NotNull Component component, PixelWidthSource source) {
        return CenterAPI.center(component, source, Component.space());
    }

    public static Component center(@NotNull Component component) {
        return CenterAPI.center(component, PixelWidthSource.pixelWidth());
    }
}

