/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import software.xdev.mockserver.matchers.TimeToLive;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;

public class TimeToLiveToJavaSerializer
implements ToJavaSerializer<TimeToLive> {
    @Override
    public String serialize(int numberOfSpacesToIndent, TimeToLive timeToLive) {
        StringBuilder output = new StringBuilder(32);
        if (timeToLive != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            if (timeToLive.isUnlimited()) {
                output.append("TimeToLive.unlimited()");
            } else {
                output.append("TimeToLive.exactly(TimeUnit.").append(timeToLive.getTimeUnit().name()).append(", ").append(timeToLive.getTimeToLive()).append("L)");
            }
        }
        return output.toString();
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

