/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.Cookie;
import software.xdev.mockserver.model.Header;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.model.Parameter;
import software.xdev.mockserver.model.ParameterBody;
import software.xdev.mockserver.model.RegexBody;
import software.xdev.mockserver.model.StringBody;
import software.xdev.mockserver.serialization.Base64Converter;
import software.xdev.mockserver.serialization.java.CookieToJavaSerializer;
import software.xdev.mockserver.serialization.java.HeaderToJavaSerializer;
import software.xdev.mockserver.serialization.java.MultiValueToJavaSerializer;
import software.xdev.mockserver.serialization.java.ParameterToJavaSerializer;
import software.xdev.mockserver.serialization.java.SocketAddressToJavaSerializer;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;
import software.xdev.mockserver.util.StringUtils;

public class HttpRequestToJavaSerializer
implements ToJavaSerializer<HttpRequest> {
    public String serialize(List<HttpRequest> httpRequests) {
        StringBuilder output = new StringBuilder(50);
        for (HttpRequest httpRequest : httpRequests) {
            output.append(this.serialize(0, httpRequest)).append(';').append("\n");
        }
        return output.toString();
    }

    @Override
    public String serialize(int numberOfSpacesToIndent, HttpRequest request) {
        StringBuilder output = new StringBuilder(50);
        if (request != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            output.append("request()");
            if (StringUtils.isNotBlank((String)request.getMethod().getValue())) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withMethod(\"").append(request.getMethod().getValue()).append("\")");
            }
            if (StringUtils.isNotBlank((String)request.getPath().getValue())) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withPath(\"").append(request.getPath().getValue()).append("\")");
            }
            this.outputHeaders(numberOfSpacesToIndent + 1, output, request.getHeaderList());
            this.outputCookies(numberOfSpacesToIndent + 1, output, request.getCookieList());
            this.outputQueryStringParameter(numberOfSpacesToIndent + 1, output, request.getQueryStringParameterList());
            if (request.isKeepAlive() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withKeepAlive(").append(request.isKeepAlive().toString()).append(')');
            }
            if (request.getProtocol() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withProtocol(Protocol.").append(request.getProtocol().toString()).append(')');
            }
            if (request.getSocketAddress() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withSocketAddress(").append(new SocketAddressToJavaSerializer().serialize(numberOfSpacesToIndent + 2, request.getSocketAddress()));
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(')');
            }
            if (request.getBody() != null) {
                Body body = request.getBody();
                if (body instanceof RegexBody) {
                    RegexBody regexBody = (RegexBody)body;
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(new RegexBody(\"").append(StringEscapeUtils.escapeJava((String)regexBody.getValue())).append("\"))");
                } else {
                    body = request.getBody();
                    if (body instanceof StringBody) {
                        StringBody stringBody = (StringBody)body;
                        this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                        output.append(".withBody(new StringBody(\"").append(StringEscapeUtils.escapeJava((String)stringBody.getValue())).append("\"))");
                    } else if (request.getBody() instanceof ParameterBody) {
                        this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                        output.append(".withBody(");
                        this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output);
                        output.append("new ParameterBody(");
                        List bodyParameters = ((ParameterBody)request.getBody()).getValue().getEntries();
                        output.append(new ParameterToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 3, bodyParameters));
                        this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output);
                        output.append(')');
                        this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                        output.append(')');
                    } else {
                        body = request.getBody();
                        if (body instanceof BinaryBody) {
                            BinaryBody body2 = (BinaryBody)body;
                            this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                            output.append(".withBody(Base64Converter.base64StringToBytes(\"").append(Base64Converter.bytesToBase64String((byte[])body2.getRawBytes())).append("\"))");
                        }
                    }
                }
            }
        }
        return output.toString();
    }

    private void outputQueryStringParameter(int numberOfSpacesToIndent, StringBuilder output, List<Parameter> parameters) {
        if (!parameters.isEmpty()) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withQueryStringParameters(");
            this.appendObject(numberOfSpacesToIndent, output, new ParameterToJavaSerializer(), parameters);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
        }
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuilder output, List<Cookie> cookies) {
        if (!cookies.isEmpty()) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withCookies(");
            this.appendObject(numberOfSpacesToIndent, output, new CookieToJavaSerializer(), cookies);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuilder output, List<Header> headers) {
        if (!headers.isEmpty()) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withHeaders(");
            this.appendObject(numberOfSpacesToIndent, output, new HeaderToJavaSerializer(), headers);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
        }
    }

    private <T extends ObjectWithJsonToString> void appendObject(int numberOfSpacesToIndent, StringBuilder output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent + 1, objects));
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

