/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import software.xdev.mockserver.model.HttpError;
import software.xdev.mockserver.serialization.Base64Converter;
import software.xdev.mockserver.serialization.java.DelayToJavaSerializer;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;

public class HttpErrorToJavaSerializer
implements ToJavaSerializer<HttpError> {
    @Override
    public String serialize(int numberOfSpacesToIndent, HttpError httpError) {
        StringBuilder output = new StringBuilder();
        if (httpError != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("error()");
            if (httpError.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(").append(new DelayToJavaSerializer().serialize(0, httpError.getDelay())).append(')');
            }
            if (httpError.getDropConnection() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDropConnection(").append(httpError.getDropConnection()).append(')');
            }
            if (httpError.getResponseBytes() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withResponseBytes(Base64Converter().base64StringToBytes(\"").append(Base64Converter.bytesToBase64String((byte[])httpError.getResponseBytes())).append("\"))");
            }
        }
        return output.toString();
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

