/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import java.util.Arrays;
import java.util.List;
import software.xdev.mockserver.model.Header;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.serialization.java.MultiValueToJavaSerializer;
import software.xdev.mockserver.serialization.java.NottableStringToJavaSerializer;

public class HeaderToJavaSerializer
implements MultiValueToJavaSerializer<Header> {
    @Override
    public String serialize(int numberOfSpacesToIndent, Header header) {
        StringBuilder output = new StringBuilder();
        output.append("\n").append(" ".repeat(numberOfSpacesToIndent * 8));
        String serializedKey = NottableStringToJavaSerializer.serialize(header.getName(), false);
        output.append("new Header(").append(serializedKey);
        for (NottableString value : header.getValues()) {
            output.append(", ").append(NottableStringToJavaSerializer.serialize(value, serializedKey.endsWith(")")));
        }
        output.append(')');
        return output.toString();
    }

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, List<Header> headers) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < headers.size(); ++i) {
            output.append(this.serialize(numberOfSpacesToIndent, headers.get(i)));
            if (i >= headers.size() - 1) continue;
            output.append(',');
        }
        return output.toString();
    }

    public String serializeAsJava(int numberOfSpacesToIndent, Header ... object) {
        return this.serializeAsJava(numberOfSpacesToIndent, Arrays.asList(object));
    }
}

