/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty.websocketregistry;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import software.xdev.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import software.xdev.mockserver.codec.MockServerHttpServerCodec;
import software.xdev.mockserver.exception.ExceptionHandling;
import software.xdev.mockserver.mock.HttpState;
import software.xdev.mockserver.netty.HttpRequestHandler;
import software.xdev.mockserver.netty.unification.PortUnificationHandler;
import software.xdev.mockserver.uuid.UUIDService;

@ChannelHandler.Sharable
public class CallbackWebSocketServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackWebSocketServerHandler.class);
    private static final AttributeKey<Boolean> CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET = AttributeKey.valueOf((String)"CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET");
    private static final String UPGRADE_CHANNEL_FOR_CALLBACK_WEB_SOCKET_URI = "/_mockserver_callback_websocket";
    private WebSocketServerHandshaker handshaker;
    private final WebSocketClientRegistry webSocketClientRegistry;

    public CallbackWebSocketServerHandler(HttpState httpStateHandler) {
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        boolean release = true;
        try {
            FullHttpRequest fullHttpRequest;
            if (msg instanceof FullHttpRequest && UPGRADE_CHANNEL_FOR_CALLBACK_WEB_SOCKET_URI.equals((fullHttpRequest = (FullHttpRequest)msg).uri())) {
                this.upgradeChannel(ctx, fullHttpRequest);
                ctx.channel().attr(CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET).set((Object)true);
            } else if (ctx.channel().attr(CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET).get() != null && ((Boolean)ctx.channel().attr(CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET).get()).booleanValue() && msg instanceof WebSocketFrame) {
                WebSocketFrame webSocketFrame = (WebSocketFrame)msg;
                this.handleWebSocketFrame(ctx, webSocketFrame);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void upgradeChannel(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        this.handshaker = new WebSocketServerHandshakerFactory((PortUnificationHandler.isSslEnabledUpstream(ctx.channel()) ? "wss" : "ws") + "://" + httpRequest.headers().get("Host") + UPGRADE_CHANNEL_FOR_CALLBACK_WEB_SOCKET_URI, null, true, Integer.MAX_VALUE).newHandshaker((HttpRequest)httpRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            String clientId;
            String string = clientId = httpRequest.headers().contains("X-CLIENT-REGISTRATION-ID") ? httpRequest.headers().get("X-CLIENT-REGISTRATION-ID") : UUIDService.getUUID();
            if (LocalCallbackRegistry.responseClientExists((String)clientId) || LocalCallbackRegistry.forwardClientExists((String)clientId)) {
                DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.RESET_CONTENT, ctx.channel().alloc().buffer(0));
                HttpUtil.setContentLength((HttpMessage)res, (long)0L);
                ctx.channel().writeAndFlush((Object)res, ctx.channel().newPromise());
            } else {
                this.handshaker.handshake(ctx.channel(), httpRequest, new DefaultHttpHeaders().add("X-CLIENT-REGISTRATION-ID", (Object)clientId), ctx.channel().newPromise()).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    ctx.pipeline().remove(MockServerHttpServerCodec.class);
                    ctx.pipeline().remove(HttpRequestHandler.class);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Registering client {}", (Object)clientId);
                    }
                    this.webSocketClientRegistry.registerClient(clientId, ctx);
                    future.channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)closeFuture -> {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Unregistering callback for client {}", (Object)clientId);
                        }
                        this.webSocketClientRegistry.unregisterClient(clientId);
                    }));
                }));
            }
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
        } else if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame txtWebSocketFrame = (TextWebSocketFrame)frame;
            this.webSocketClientRegistry.receivedTextWebSocketFrame(txtWebSocketFrame);
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.write((Object)new PongWebSocketFrame(frame.content().retain()));
        } else {
            throw new UnsupportedOperationException(frame.getClass().getName() + " frame types not supported");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            LOG.error("Web socket server caught exception", cause);
        }
        ctx.close();
    }
}

