/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty.responsewriter;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.model.ConnectionOptions;
import software.xdev.mockserver.model.Delay;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.responsewriter.ResponseWriter;
import software.xdev.mockserver.scheduler.Scheduler;

public class NettyResponseWriter
extends ResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(NettyResponseWriter.class);
    private final ChannelHandlerContext ctx;
    private final Scheduler scheduler;

    public NettyResponseWriter(ServerConfiguration configuration, ChannelHandlerContext ctx, Scheduler scheduler) {
        super(configuration);
        this.ctx = ctx;
        this.scheduler = scheduler;
    }

    @Override
    public void sendResponse(HttpRequest request, HttpResponse response) {
        this.writeAndCloseSocket(this.ctx, request, response);
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        boolean closeChannel = connectionOptions != null && connectionOptions.getCloseSocket() != null ? connectionOptions.getCloseSocket() : request.isKeepAlive() == null || request.isKeepAlive() == false;
        ChannelFuture channelFuture = ctx.writeAndFlush((Object)response);
        if (closeChannel || this.configuration.alwaysCloseSocketConnections().booleanValue()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                Delay closeSocketDelay;
                Delay delay = closeSocketDelay = connectionOptions != null ? connectionOptions.getCloseSocketDelay() : null;
                if (closeSocketDelay == null) {
                    this.disconnectAndCloseChannel((ChannelFuture)future);
                } else {
                    this.scheduler.schedule(() -> this.disconnectAndCloseChannel((ChannelFuture)future), false, closeSocketDelay);
                }
            }));
        }
    }

    private void disconnectAndCloseChannel(ChannelFuture future) {
        future.channel().disconnect().addListener(disconnectFuture -> {
            if (disconnectFuture.isSuccess()) {
                future.channel().close().addListener(closeFuture -> {
                    if (disconnectFuture.isSuccess()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Disconnected and closed socket {}", (Object)future.channel().localAddress());
                        }
                    } else if (LOG.isWarnEnabled()) {
                        LOG.warn("Exception closing socket {}", (Object)future.channel().localAddress());
                    }
                });
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("Exception disconnecting socket {}", (Object)future.channel().localAddress(), (Object)disconnectFuture.cause());
            }
        });
    }
}

