/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty.proxy.socks;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.socksx.SocksVersion;
import io.netty.handler.codec.socksx.v4.Socks4CommandType;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;

public final class SocksDetector {
    private SocksDetector() {
    }

    public static boolean isSocks4(ByteBuf msg, int actualReadableBytes) {
        Socks4CommandType commandType;
        int i = msg.readerIndex();
        if (SocksVersion.valueOf((byte)msg.getByte(i++)) != SocksVersion.SOCKS4a) {
            return false;
        }
        if (!(commandType = Socks4CommandType.valueOf((byte)msg.getByte(i++))).equals((Object)Socks4CommandType.CONNECT) && !commandType.equals((Object)Socks4CommandType.BIND)) {
            return false;
        }
        if (-1 == (i = SocksDetector.consumeFields(msg, i + 2))) {
            return false;
        }
        return i == actualReadableBytes;
    }

    private static int consumeFields(ByteBuf msg, int i) {
        boolean socks4a = msg.getByte(i++) == 0 && msg.getByte(i) == 0 && msg.getByte(i + 1) == 0 && msg.getByte(i + 2) != 0;
        if (-1 == (i = SocksDetector.consumeUsername(msg, i + 3))) {
            return -1;
        }
        if (socks4a && -1 == (i = SocksDetector.consumeHostname(msg, i))) {
            return -1;
        }
        return i;
    }

    private static int consumeUsername(ByteBuf msg, int i) {
        int j = i + 256;
        while (i < j && msg.getByte(i) != 0) {
            ++i;
        }
        if (i == j) {
            return -1;
        }
        return i + 1;
    }

    private static int consumeHostname(ByteBuf msg, int i) {
        if (msg.getByte(i) == 0) {
            return -1;
        }
        int j = i + 256;
        while (++i < j && msg.getByte(i) != 0) {
        }
        if (i == j) {
            return -1;
        }
        return i + 1;
    }

    public static boolean isSocks5(ByteBuf msg, int actualReadableBytes) {
        if (SocksVersion.valueOf((byte)msg.getByte(msg.readerIndex())) != SocksVersion.SOCKS5) {
            return false;
        }
        int numberOfAuthenticationMethods = msg.getByte(msg.readerIndex() + 1);
        for (int i = 0; i < numberOfAuthenticationMethods; ++i) {
            Socks5AuthMethod authMethod = Socks5AuthMethod.valueOf((byte)msg.getByte(msg.readerIndex() + 2 + i));
            if (Socks5AuthMethod.NO_AUTH.equals((Object)authMethod) || Socks5AuthMethod.PASSWORD.equals((Object)authMethod) || Socks5AuthMethod.GSSAPI.equals((Object)authMethod)) continue;
            return false;
        }
        return actualReadableBytes == 2 + numberOfAuthenticationMethods;
    }
}

