/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import java.util.Objects;
import software.xdev.mockserver.matchers.BodyMatcher;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.util.StringUtils;

public class SubStringMatcher
extends BodyMatcher<NottableString> {
    private final NottableString matcher;

    SubStringMatcher(NottableString matcher) {
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        if (StringUtils.isEmpty((String)matcher)) {
            return true;
        }
        if (matched != null) {
            if (matched.contains(matcher)) {
                return true;
            }
            if (ignoreCase) {
                return matched.toLowerCase().contains(matcher.toLowerCase());
            }
        }
        return false;
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        return this.matches(context, NottableString.string((String)matched));
    }

    @Override
    public boolean matches(MatchDifference context, NottableString matched) {
        boolean result;
        if (this.matcher == null) {
            return true;
        }
        boolean bl = result = matched != null && SubStringMatcher.matches(this.matcher.getValue(), matched.getValue(), false);
        if (!result && context != null) {
            context.addDifference("substring match failed expected:{}found:{}", this.matcher, matched);
        }
        if (matched == null) {
            return false;
        }
        return matched.isNot() == (this.matcher.isNot() == (this.not != result));
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank((String)this.matcher.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubStringMatcher)) {
            return false;
        }
        SubStringMatcher that = (SubStringMatcher)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.matcher, that.matcher);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.matcher);
    }
}

