/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.matchers.BodyMatcher;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.util.StringUtils;

public class RegexStringMatcher
extends BodyMatcher<NottableString> {
    private static final Logger LOG = LoggerFactory.getLogger(RegexStringMatcher.class);
    private final NottableString matcher;
    private final boolean controlPlaneMatcher;

    public RegexStringMatcher(boolean controlPlaneMatcher) {
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = null;
    }

    RegexStringMatcher(NottableString matcher, boolean controlPlaneMatcher) {
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = matcher;
    }

    public boolean matches(String matched) {
        return this.matches((MatchDifference)null, NottableString.string((String)matched));
    }

    @Override
    public boolean matches(MatchDifference context, NottableString matched) {
        boolean result = this.matcher == null || this.matches(context, this.matcher, matched);
        return this.not != result;
    }

    public boolean matches(NottableString matcher, NottableString matched) {
        return this.matches(null, matcher, matched);
    }

    public boolean matches(MatchDifference context, NottableString matcher, NottableString matched) {
        return this.matchesByNottedStrings(context, matcher, matched);
    }

    private boolean matchesByNottedStrings(MatchDifference context, NottableString matcher, NottableString matched) {
        if (matcher.isNot() && matched.isNot()) {
            return this.matchesByStrings(context, matcher, matched);
        }
        return (matcher.isNot() || matched.isNot()) ^ this.matchesByStrings(context, matcher, matched);
    }

    private boolean matchesByStrings(MatchDifference context, NottableString matcher, NottableString matched) {
        block13: {
            String matchedValue;
            if (matcher == null) {
                return true;
            }
            String matcherValue = matcher.getValue();
            if (StringUtils.isBlank((String)matcherValue)) {
                return true;
            }
            if (matched != null && (matchedValue = matched.getValue()) != null) {
                block12: {
                    if (matchedValue.equals(matcherValue) || matchedValue.equalsIgnoreCase(matcherValue)) {
                        return true;
                    }
                    try {
                        if (matcher.matches(matchedValue)) {
                            return true;
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        if (!LOG.isDebugEnabled()) break block12;
                        LOG.debug("Error while matching regex [{}] for string [{}]", new Object[]{matcher, matched, pse});
                    }
                }
                try {
                    if (this.controlPlaneMatcher && matched.matches(matcherValue)) {
                        return true;
                    }
                    if (LOG.isDebugEnabled() && matched.matches(matcherValue)) {
                        LOG.debug("Matcher {} would match {} if matcher was used for control plane", (Object)matcher, (Object)matched);
                    }
                }
                catch (PatternSyntaxException pse) {
                    if (!this.controlPlaneMatcher || !LOG.isDebugEnabled()) break block13;
                    LOG.debug("Error while matching regex [{}] for string [{}]", new Object[]{matcher, matched, pse});
                }
            }
        }
        if (context != null) {
            context.addDifference("string or regex match failed expected:{}found:{}", matcher, matched);
        }
        return false;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank((String)this.matcher.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegexStringMatcher)) {
            return false;
        }
        RegexStringMatcher that = (RegexStringMatcher)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.controlPlaneMatcher == that.controlPlaneMatcher && Objects.equals(this.matcher, that.matcher);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.matcher, this.controlPlaneMatcher);
    }
}

