/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.logging;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.LogManager;
import software.xdev.mockserver.configuration.ServerConfigurationProperties;
import software.xdev.mockserver.util.StringUtils;

public final class MockServerLoggerConfiguration {
    public static void configureLogger() {
        try {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                LogManager.getLogManager().readConfiguration(new ByteArrayInputStream("handlers=software.xdev.mockserver.logging.StandardOutConsoleHandler\nsoftware.xdev.mockserver.logging.StandardOutConsoleHandler.level=ALL\nsoftware.xdev.mockserver.logging.StandardOutConsoleHandler.formatter=java.util.logging.SimpleFormatter\njava.util.logging.SimpleFormatter.format=%1$tF %1$tT %4$s %5$s %6$s%n\nsoftware.xdev.mockserver.level=INFO\nio.netty.level=WARNING".getBytes(StandardCharsets.UTF_8)));
                if (StringUtils.isNotBlank((String)ServerConfigurationProperties.javaLoggerLogLevel())) {
                    String loggingConfiguration = (!ServerConfigurationProperties.disableSystemOut() ? "handlers=software.xdev.mockserver.logging.StandardOutConsoleHandler\nsoftware.xdev.mockserver.logging.StandardOutConsoleHandler.level=ALL\nsoftware.xdev.mockserver.logging.StandardOutConsoleHandler.formatter=java.util.logging.SimpleFormatter\n" : "") + "java.util.logging.SimpleFormatter.format=%1$tF %1$tT %4$s %5$s %6$s%n\nsoftware.xdev.mockserver.level=" + ServerConfigurationProperties.javaLoggerLogLevel() + "\nio.netty.level=" + (Arrays.asList("TRACE", "FINEST").contains(ServerConfigurationProperties.javaLoggerLogLevel()) ? "FINE" : "WARNING");
                    LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(loggingConfiguration.getBytes(StandardCharsets.UTF_8)));
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Failed to configure logger");
            ex.printStackTrace();
        }
    }

    private MockServerLoggerConfiguration() {
    }
}

