/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.exception;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.net.ConnectException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import software.xdev.mockserver.httpclient.SocketConnectionException;

public final class ExceptionHandling {
    private static final Predicate<String> IGNORABLE_CLASS_IN_STACK_PRE_CHECK = s -> s.contains("Channel");
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Predicate<String> IGNORABLE_ERROR_MESSAGE_PRE_CHECK = s -> s.toLowerCase().contains("connection") || s.toLowerCase().contains("broken");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final List<Class<? extends Exception>> SSL_HANDSHAKE_FAILURE_CLASSES = Arrays.asList(SSLException.class, SSLHandshakeException.class, CertPathValidatorException.class, SignatureException.class);
    private static final List<Class<? extends Exception>> CONNECTION_EXCEPTION_CLASSES = Arrays.asList(SocketConnectionException.class, ConnectException.class);

    public static void closeOnFlush(Channel ch) {
        if (ch != null && ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public static boolean connectionClosedException(Throwable throwable) {
        StackTraceElement[] elements;
        if (throwable.getCause() instanceof SSLException || throwable instanceof DecoderException || throwable instanceof NotSslRecordException) {
            return false;
        }
        String message = String.valueOf(throwable.getMessage()).toLowerCase();
        if (IGNORABLE_ERROR_MESSAGE_PRE_CHECK.test(message) && IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
            return false;
        }
        for (StackTraceElement element : elements = throwable.getStackTrace()) {
            String classname = element.getClassName();
            String methodname = element.getMethodName();
            if (classname.startsWith("io.netty.") || !"read".equals(methodname)) continue;
            if (IGNORABLE_CLASS_IN_STACK_PRE_CHECK.test(classname) && IGNORABLE_CLASS_IN_STACK.matcher(classname).matches()) {
                return false;
            }
            try {
                Class<?> clazz = PlatformDependent.getClassLoader(ExceptionHandling.class).loadClass(classname);
                if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                    return false;
                }
                if (!"com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) continue;
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean sslHandshakeException(Throwable throwable) {
        for (Class<? extends Throwable> cause : ExceptionHandling.getCauses(throwable)) {
            if (!SSL_HANDSHAKE_FAILURE_CLASSES.contains(cause)) continue;
            return true;
        }
        return false;
    }

    public static boolean connectionException(Throwable throwable) {
        for (Class<? extends Throwable> cause : ExceptionHandling.getCauses(throwable)) {
            if (!CONNECTION_EXCEPTION_CLASSES.contains(cause)) continue;
            return true;
        }
        return false;
    }

    private static List<Class<? extends Throwable>> getCauses(Throwable throwable) {
        if (throwable.getCause() != null) {
            if (throwable.getClass().equals(throwable.getCause().getClass())) {
                return new ArrayList<Class<? extends Throwable>>(Collections.singletonList(throwable.getClass()));
            }
            List<Class<? extends Throwable>> causes = ExceptionHandling.getCauses(throwable.getCause());
            causes.add(throwable.getClass());
            return causes;
        }
        return new ArrayList<Class<? extends Throwable>>(Collections.singletonList(throwable.getClass()));
    }

    private ExceptionHandling() {
    }
}

