/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.configuration;

import software.xdev.mockserver.configuration.Configuration;
import software.xdev.mockserver.configuration.ServerConfigurationProperties;
import software.xdev.mockserver.model.BinaryProxyListener;

public class ServerConfiguration
extends Configuration {
    private Boolean detailedMatchFailures;
    private Integer maxExpectations;
    private Integer maxLogEntries;
    private Integer nioEventLoopThreadCount;
    private Integer actionHandlerThreadCount;
    private Boolean matchersFailFast;
    private Boolean alwaysCloseSocketConnections;
    private String localBoundIP;
    private Integer maxInitialLineLength;
    private Integer maxHeaderSize;
    private Integer maxChunkSize;
    private Boolean useSemicolonAsQueryParameterSeparator;
    private Boolean assumeAllRequestsAreHttp;
    private BinaryProxyListener binaryProxyListener;
    private Boolean enableCORSForAPI;
    private Boolean enableCORSForAllResponses;
    private String corsAllowOrigin;
    private String corsAllowMethods;
    private String corsAllowHeaders;
    private Boolean corsAllowCredentials;
    private Integer corsMaxAgeInSeconds;
    private Integer maximumNumberOfRequestToReturnInVerificationFailure;
    private String proxyAuthenticationRealm;
    private String proxyAuthenticationUsername;
    private String proxyAuthenticationPassword;
    private String noProxyHosts;
    private String livenessHttpGetPath;

    public static ServerConfiguration configuration() {
        return new ServerConfiguration();
    }

    public Boolean detailedMatchFailures() {
        if (this.detailedMatchFailures == null) {
            return ServerConfigurationProperties.detailedMatchFailures();
        }
        return this.detailedMatchFailures;
    }

    public ServerConfiguration detailedMatchFailures(Boolean detailedMatchFailures) {
        this.detailedMatchFailures = detailedMatchFailures;
        return this;
    }

    public Integer maxExpectations() {
        if (this.maxExpectations == null) {
            return ServerConfigurationProperties.maxExpectations();
        }
        return this.maxExpectations;
    }

    public ServerConfiguration maxExpectations(Integer maxExpectations) {
        this.maxExpectations = maxExpectations;
        return this;
    }

    public Integer maxLogEntries() {
        if (this.maxLogEntries == null) {
            return ServerConfigurationProperties.maxLogEntries();
        }
        return this.maxLogEntries;
    }

    public ServerConfiguration maxLogEntries(Integer maxLogEntries) {
        this.maxLogEntries = maxLogEntries;
        return this;
    }

    public Integer nioEventLoopThreadCount() {
        if (this.nioEventLoopThreadCount == null) {
            return ServerConfigurationProperties.nioEventLoopThreadCount();
        }
        return this.nioEventLoopThreadCount;
    }

    public ServerConfiguration nioEventLoopThreadCount(Integer nioEventLoopThreadCount) {
        this.nioEventLoopThreadCount = nioEventLoopThreadCount;
        return this;
    }

    public Integer actionHandlerThreadCount() {
        if (this.actionHandlerThreadCount == null) {
            return ServerConfigurationProperties.actionHandlerThreadCount();
        }
        return this.actionHandlerThreadCount;
    }

    public ServerConfiguration actionHandlerThreadCount(Integer actionHandlerThreadCount) {
        this.actionHandlerThreadCount = actionHandlerThreadCount;
        return this;
    }

    public Boolean matchersFailFast() {
        if (this.matchersFailFast == null) {
            return ServerConfigurationProperties.matchersFailFast();
        }
        return this.matchersFailFast;
    }

    public ServerConfiguration matchersFailFast(Boolean matchersFailFast) {
        this.matchersFailFast = matchersFailFast;
        return this;
    }

    public Boolean alwaysCloseSocketConnections() {
        if (this.alwaysCloseSocketConnections == null) {
            return ServerConfigurationProperties.alwaysCloseSocketConnections();
        }
        return this.alwaysCloseSocketConnections;
    }

    public ServerConfiguration alwaysCloseSocketConnections(Boolean alwaysCloseSocketConnections) {
        this.alwaysCloseSocketConnections = alwaysCloseSocketConnections;
        return this;
    }

    public String localBoundIP() {
        if (this.localBoundIP == null) {
            return ServerConfigurationProperties.localBoundIP();
        }
        return this.localBoundIP;
    }

    public ServerConfiguration localBoundIP(String localBoundIP) {
        this.localBoundIP = localBoundIP;
        return this;
    }

    public Integer maxInitialLineLength() {
        if (this.maxInitialLineLength == null) {
            return ServerConfigurationProperties.maxInitialLineLength();
        }
        return this.maxInitialLineLength;
    }

    public ServerConfiguration maxInitialLineLength(Integer maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    public Integer maxHeaderSize() {
        if (this.maxHeaderSize == null) {
            return ServerConfigurationProperties.maxHeaderSize();
        }
        return this.maxHeaderSize;
    }

    public ServerConfiguration maxHeaderSize(Integer maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    public Integer maxChunkSize() {
        if (this.maxChunkSize == null) {
            return ServerConfigurationProperties.maxChunkSize();
        }
        return this.maxChunkSize;
    }

    public ServerConfiguration maxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public Boolean useSemicolonAsQueryParameterSeparator() {
        if (this.useSemicolonAsQueryParameterSeparator == null) {
            return ServerConfigurationProperties.useSemicolonAsQueryParameterSeparator();
        }
        return this.useSemicolonAsQueryParameterSeparator;
    }

    public ServerConfiguration useSemicolonAsQueryParameterSeparator(Boolean useSemicolonAsQueryParameterSeparator) {
        this.useSemicolonAsQueryParameterSeparator = useSemicolonAsQueryParameterSeparator;
        return this;
    }

    public Boolean assumeAllRequestsAreHttp() {
        if (this.assumeAllRequestsAreHttp == null) {
            return ServerConfigurationProperties.assumeAllRequestsAreHttp();
        }
        return this.assumeAllRequestsAreHttp;
    }

    public ServerConfiguration assumeAllRequestsAreHttp(Boolean assumeAllRequestsAreHttp) {
        this.assumeAllRequestsAreHttp = assumeAllRequestsAreHttp;
        return this;
    }

    public BinaryProxyListener binaryProxyListener() {
        return this.binaryProxyListener;
    }

    public ServerConfiguration binaryProxyListener(BinaryProxyListener binaryProxyListener) {
        this.binaryProxyListener = binaryProxyListener;
        return this;
    }

    public Boolean enableCORSForAPI() {
        if (this.enableCORSForAPI == null) {
            return ServerConfigurationProperties.enableCORSForAPI();
        }
        return this.enableCORSForAPI;
    }

    public ServerConfiguration enableCORSForAPI(Boolean enableCORSForAPI) {
        this.enableCORSForAPI = enableCORSForAPI;
        return this;
    }

    public Boolean enableCORSForAllResponses() {
        if (this.enableCORSForAllResponses == null) {
            return ServerConfigurationProperties.enableCORSForAllResponses();
        }
        return this.enableCORSForAllResponses;
    }

    public ServerConfiguration enableCORSForAllResponses(Boolean enableCORSForAllResponses) {
        this.enableCORSForAllResponses = enableCORSForAllResponses;
        return this;
    }

    public String corsAllowOrigin() {
        if (this.corsAllowOrigin == null) {
            return ServerConfigurationProperties.corsAllowOrigin();
        }
        return this.corsAllowOrigin;
    }

    public ServerConfiguration corsAllowOrigin(String corsAllowOrigin) {
        this.corsAllowOrigin = corsAllowOrigin;
        return this;
    }

    public String corsAllowMethods() {
        if (this.corsAllowMethods == null) {
            return ServerConfigurationProperties.corsAllowMethods();
        }
        return this.corsAllowMethods;
    }

    public ServerConfiguration corsAllowMethods(String corsAllowMethods) {
        this.corsAllowMethods = corsAllowMethods;
        return this;
    }

    public String corsAllowHeaders() {
        if (this.corsAllowHeaders == null) {
            return ServerConfigurationProperties.corsAllowHeaders();
        }
        return this.corsAllowHeaders;
    }

    public ServerConfiguration corsAllowHeaders(String corsAllowHeaders) {
        this.corsAllowHeaders = corsAllowHeaders;
        return this;
    }

    public Boolean corsAllowCredentials() {
        if (this.corsAllowCredentials == null) {
            return ServerConfigurationProperties.corsAllowCredentials();
        }
        return this.corsAllowCredentials;
    }

    public ServerConfiguration corsAllowCredentials(Boolean corsAllowCredentials) {
        this.corsAllowCredentials = corsAllowCredentials;
        return this;
    }

    public Integer corsMaxAgeInSeconds() {
        if (this.corsMaxAgeInSeconds == null) {
            return ServerConfigurationProperties.corsMaxAgeInSeconds();
        }
        return this.corsMaxAgeInSeconds;
    }

    public ServerConfiguration corsMaxAgeInSeconds(Integer corsMaxAgeInSeconds) {
        this.corsMaxAgeInSeconds = corsMaxAgeInSeconds;
        return this;
    }

    public Integer maximumNumberOfRequestToReturnInVerificationFailure() {
        if (this.maximumNumberOfRequestToReturnInVerificationFailure == null) {
            return ServerConfigurationProperties.maximumNumberOfRequestToReturnInVerificationFailure();
        }
        return this.maximumNumberOfRequestToReturnInVerificationFailure;
    }

    public ServerConfiguration maximumNumberOfRequestToReturnInVerificationFailure(Integer maximumNumberOfRequestToReturnInVerificationFailure) {
        this.maximumNumberOfRequestToReturnInVerificationFailure = maximumNumberOfRequestToReturnInVerificationFailure;
        return this;
    }

    public String proxyAuthenticationRealm() {
        if (this.proxyAuthenticationRealm == null) {
            return ServerConfigurationProperties.proxyAuthenticationRealm();
        }
        return this.proxyAuthenticationRealm;
    }

    public ServerConfiguration proxyAuthenticationRealm(String proxyAuthenticationRealm) {
        this.proxyAuthenticationRealm = proxyAuthenticationRealm;
        return this;
    }

    public String proxyAuthenticationUsername() {
        if (this.proxyAuthenticationUsername == null) {
            return ServerConfigurationProperties.proxyAuthenticationUsername();
        }
        return this.proxyAuthenticationUsername;
    }

    public ServerConfiguration proxyAuthenticationUsername(String proxyAuthenticationUsername) {
        this.proxyAuthenticationUsername = proxyAuthenticationUsername;
        return this;
    }

    public String proxyAuthenticationPassword() {
        if (this.proxyAuthenticationPassword == null) {
            return ServerConfigurationProperties.proxyAuthenticationPassword();
        }
        return this.proxyAuthenticationPassword;
    }

    public ServerConfiguration proxyAuthenticationPassword(String proxyAuthenticationPassword) {
        this.proxyAuthenticationPassword = proxyAuthenticationPassword;
        return this;
    }

    public String noProxyHosts() {
        if (this.noProxyHosts == null) {
            return ServerConfigurationProperties.noProxyHosts();
        }
        return this.noProxyHosts;
    }

    public ServerConfiguration noProxyHosts(String noProxyHosts) {
        this.noProxyHosts = noProxyHosts;
        return this;
    }

    public String livenessHttpGetPath() {
        if (this.livenessHttpGetPath == null) {
            return ServerConfigurationProperties.livenessHttpGetPath();
        }
        return this.livenessHttpGetPath;
    }

    public ServerConfiguration livenessHttpGetPath(String livenessHttpGetPath) {
        this.livenessHttpGetPath = livenessHttpGetPath;
        return this;
    }

    public int ringBufferSize() {
        return this.nextPowerOfTwo(this.maxLogEntries());
    }

    private int nextPowerOfTwo(int value) {
        for (int i = 0; i < 16; ++i) {
            double powOfTwo = Math.pow(2.0, i);
            if (!(powOfTwo > (double)value)) continue;
            return (int)powOfTwo;
        }
        return (int)Math.pow(2.0, 16.0);
    }
}

