/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.xdev.mockserver.collections.ImmutableEntry;
import software.xdev.mockserver.collections.SubSetMatcher;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.RegexStringMatcher;
import software.xdev.mockserver.model.KeyAndValue;
import software.xdev.mockserver.model.NottableString;

public class NottableStringHashMap {
    private final Map<NottableString, NottableString> backingMap = new LinkedHashMap<NottableString, NottableString>();
    private final RegexStringMatcher regexStringMatcher;

    public NottableStringHashMap(boolean controlPlaneMatcher, List<? extends KeyAndValue> entries) {
        this.regexStringMatcher = new RegexStringMatcher(controlPlaneMatcher);
        for (KeyAndValue keyAndValue : entries) {
            this.put(keyAndValue.getName(), keyAndValue.getValue());
        }
    }

    public NottableStringHashMap(boolean controlPlaneMatcher, NottableString[] ... keyAndValues) {
        this.regexStringMatcher = new RegexStringMatcher(controlPlaneMatcher);
        for (NottableString[] keyAndValue : keyAndValues) {
            if (keyAndValue.length < 2) continue;
            this.put(keyAndValue[0], keyAndValue[1]);
        }
    }

    public boolean containsAll(MatchDifference context, NottableStringHashMap subset) {
        return SubSetMatcher.containsSubset(context, this.regexStringMatcher, subset.entryList(), this.entryList());
    }

    public boolean allKeysNotted() {
        for (NottableString key : this.backingMap.keySet()) {
            if (key.isNot()) continue;
            return false;
        }
        return true;
    }

    public boolean allKeysOptional() {
        for (NottableString key : this.backingMap.keySet()) {
            if (key.isOptional()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    private void put(NottableString key, NottableString value) {
        this.backingMap.put(key, value != null ? value : NottableString.string((String)""));
    }

    private List<ImmutableEntry> entryList() {
        if (!this.backingMap.isEmpty()) {
            ArrayList<ImmutableEntry> entrySet = new ArrayList<ImmutableEntry>();
            for (Map.Entry<NottableString, NottableString> entry : this.backingMap.entrySet()) {
                entrySet.add(ImmutableEntry.entry(this.regexStringMatcher, entry.getKey(), entry.getValue()));
            }
            return entrySet;
        }
        return Collections.emptyList();
    }
}

