/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.BodyWithContentType;
import software.xdev.mockserver.model.Cookie;
import software.xdev.mockserver.model.Header;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.serialization.Base64Converter;
import software.xdev.mockserver.serialization.java.ConnectionOptionsToJavaSerializer;
import software.xdev.mockserver.serialization.java.CookieToJavaSerializer;
import software.xdev.mockserver.serialization.java.DelayToJavaSerializer;
import software.xdev.mockserver.serialization.java.HeaderToJavaSerializer;
import software.xdev.mockserver.serialization.java.MultiValueToJavaSerializer;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;
import software.xdev.mockserver.util.StringUtils;

public class HttpResponseToJavaSerializer
implements ToJavaSerializer<HttpResponse> {
    @Override
    public String serialize(int numberOfSpacesToIndent, HttpResponse httpResponse) {
        StringBuilder output = new StringBuilder(50);
        if (httpResponse != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("response()");
            if (httpResponse.getStatusCode() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withStatusCode(").append(httpResponse.getStatusCode()).append(')');
            }
            if (httpResponse.getReasonPhrase() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withReasonPhrase(\"").append(StringEscapeUtils.escapeJava((String)httpResponse.getReasonPhrase())).append("\")");
            }
            this.outputHeaders(numberOfSpacesToIndent + 1, output, httpResponse.getHeaderList());
            this.outputCookies(numberOfSpacesToIndent + 1, output, httpResponse.getCookieList());
            if (StringUtils.isNotBlank((String)httpResponse.getBodyAsString())) {
                BodyWithContentType bodyWithContentType = httpResponse.getBody();
                if (bodyWithContentType instanceof BinaryBody) {
                    BinaryBody body = (BinaryBody)bodyWithContentType;
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(Base64Converter.base64StringToBytes(\"").append(Base64Converter.bytesToBase64String((byte[])body.getRawBytes())).append("\"))");
                } else {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withBody(\"").append(StringEscapeUtils.escapeJava((String)httpResponse.getBodyAsString())).append("\")");
                }
            }
            if (httpResponse.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(").append(new DelayToJavaSerializer().serialize(0, httpResponse.getDelay())).append(')');
            }
            if (httpResponse.getConnectionOptions() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withConnectionOptions(");
                output.append(new ConnectionOptionsToJavaSerializer().serialize(numberOfSpacesToIndent + 2, httpResponse.getConnectionOptions()));
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(')');
            }
        }
        return output.toString();
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuilder output, List<Cookie> cookies) {
        if (!cookies.isEmpty()) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withCookies(");
            this.appendObject(numberOfSpacesToIndent + 1, output, new CookieToJavaSerializer(), cookies);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuilder output, List<Header> headers) {
        if (!headers.isEmpty()) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withHeaders(");
            this.appendObject(numberOfSpacesToIndent + 1, output, new HeaderToJavaSerializer(), headers);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(')');
        }
    }

    private <T extends ObjectWithJsonToString> void appendObject(int numberOfSpacesToIndent, StringBuilder output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent, objects));
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

