/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.responsewriter;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.cors.CORSHeaders;
import software.xdev.mockserver.model.ConnectionOptions;
import software.xdev.mockserver.model.Header;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.util.StringUtils;

public abstract class ResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseWriter.class);
    protected final ServerConfiguration configuration;
    private final CORSHeaders corsHeaders;

    protected ResponseWriter(ServerConfiguration configuration) {
        this.configuration = configuration;
        this.corsHeaders = new CORSHeaders(configuration);
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(request, responseStatus, "", "application/json");
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withReasonPhrase(responseStatus.reasonPhrase()).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.replaceHeader(Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        this.writeResponse(request, response, true);
    }

    public void writeResponse(HttpRequest request, HttpResponse response, boolean apiResponse) {
        String path;
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (this.configuration.enableCORSForAllResponses().booleanValue()) {
            this.corsHeaders.addCORSHeaders(request, response);
        } else if (apiResponse && this.configuration.enableCORSForAPI().booleanValue()) {
            this.corsHeaders.addCORSHeaders(request, response);
        }
        String contentLengthHeader = response.getFirstHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        if (StringUtils.isNotBlank((String)contentLengthHeader)) {
            try {
                int contentLength = Integer.parseInt(contentLengthHeader);
                if (response.getBodyAsRawBytes().length > contentLength) {
                    LOG.info("Returning response with content-length header {} which is smaller then response body length {}, body will likely be truncated by client receiving request", (Object)contentLength, (Object)response.getBodyAsRawBytes().length);
                }
            }
            catch (NumberFormatException contentLength) {
                // empty catch block
            }
        }
        if (apiResponse && !(path = request.getPath().getValue()).startsWith("/mockserver") && !path.equals(this.configuration.livenessHttpGetPath())) {
            response.withHeader("deprecated", new String[]{"\"" + path + "\" is deprecated use \"/mockserver" + path + "\" instead"});
        }
        if (request.getStreamId() != null) {
            response.withStreamId(request.getStreamId());
        }
        this.sendResponse(request, this.addConnectionHeader(request, response));
    }

    public abstract void sendResponse(HttpRequest var1, HttpResponse var2);

    protected HttpResponse addConnectionHeader(HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        HttpResponse responseWithConnectionHeader = response.clone();
        if (connectionOptions != null && (connectionOptions.getSuppressConnectionHeader() != null || connectionOptions.getKeepAliveOverride() != null)) {
            if (!Boolean.TRUE.equals(connectionOptions.getSuppressConnectionHeader())) {
                if (Boolean.TRUE.equals(connectionOptions.getKeepAliveOverride())) {
                    responseWithConnectionHeader.replaceHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
                } else {
                    responseWithConnectionHeader.replaceHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
                }
            }
        } else if (Boolean.TRUE.equals(request.isKeepAlive())) {
            responseWithConnectionHeader.replaceHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
        } else {
            responseWithConnectionHeader.replaceHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
        }
        return responseWithConnectionHeader;
    }
}

