/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.Configuration;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.lifecycle.ExpectationsListener;
import software.xdev.mockserver.lifecycle.LifeCycle;
import software.xdev.mockserver.mock.action.http.HttpActionHandler;
import software.xdev.mockserver.netty.HttpRequestHandler;
import software.xdev.mockserver.netty.MockServerUnificationInitializer;
import software.xdev.mockserver.proxyconfiguration.ProxyConfiguration;
import software.xdev.mockserver.util.StringUtils;

public class MockServer
extends LifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(MockServer.class);
    private InetSocketAddress remoteSocket;

    public MockServer(Integer ... localPorts) {
        this(null, (List<ProxyConfiguration>)ProxyConfiguration.proxyConfiguration((Configuration)ServerConfiguration.configuration()), localPorts);
    }

    public MockServer(ServerConfiguration configuration, Integer ... localPorts) {
        this(configuration, (List<ProxyConfiguration>)ProxyConfiguration.proxyConfiguration((Configuration)configuration), localPorts);
    }

    public MockServer(ProxyConfiguration proxyConfiguration, Integer ... localPorts) {
        this(null, List.of(proxyConfiguration), localPorts);
    }

    public MockServer(ServerConfiguration configuration, List<ProxyConfiguration> proxyConfigurations, Integer ... localPorts) {
        super(configuration);
        this.createServerBootstrap(configuration, proxyConfigurations, localPorts);
        this.getLocalPort();
    }

    public MockServer(Integer remotePort, String remoteHost, Integer ... localPorts) {
        this(null, (List<ProxyConfiguration>)ProxyConfiguration.proxyConfiguration((Configuration)ServerConfiguration.configuration()), remoteHost, remotePort, localPorts);
    }

    public MockServer(ServerConfiguration configuration, Integer remotePort, String remoteHost, Integer ... localPorts) {
        this(configuration, (List<ProxyConfiguration>)ProxyConfiguration.proxyConfiguration((Configuration)configuration), remoteHost, remotePort, localPorts);
    }

    public MockServer(ServerConfiguration configuration, ProxyConfiguration proxyConfiguration, String remoteHost, Integer remotePort, Integer ... localPorts) {
        this(configuration, List.of(proxyConfiguration), remoteHost, remotePort, localPorts);
    }

    public MockServer(ServerConfiguration configuration, List<ProxyConfiguration> proxyConfigurations, String remoteHost, Integer remotePort, Integer ... localPorts) {
        super(configuration);
        if (remotePort == null) {
            throw new IllegalArgumentException("You must specify a remote hostname");
        }
        this.remoteSocket = new InetSocketAddress(!StringUtils.isBlank((String)remoteHost) ? remoteHost : "localhost", (int)remotePort);
        if (proxyConfigurations != null && LOG.isInfoEnabled()) {
            LOG.info("Using proxy configuration for forwarded requests: {}", proxyConfigurations);
        }
        this.createServerBootstrap(configuration, proxyConfigurations, localPorts);
        this.getLocalPort();
    }

    private void createServerBootstrap(ServerConfiguration configuration, List<ProxyConfiguration> proxyConfigurations, Integer ... localPorts) {
        if (configuration == null) {
            configuration = ServerConfiguration.configuration();
        }
        List<Integer> portBindings = Collections.singletonList(0);
        if (localPorts != null && localPorts.length > 0) {
            portBindings = Arrays.asList(localPorts);
        }
        this.serverServerBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)new MockServerUnificationInitializer(configuration, this, this.httpState, new HttpActionHandler(configuration, this.getEventLoopGroup(), this.httpState, proxyConfigurations))).childAttr(HttpActionHandler.REMOTE_SOCKET, (Object)this.remoteSocket).childAttr(HttpRequestHandler.PROXYING, (Object)(this.remoteSocket != null ? 1 : 0));
        try {
            this.bindServerPorts(portBindings);
        }
        catch (Exception ex) {
            LOG.error("Exception binding to port(s) {}", portBindings);
            this.stop();
            throw ex;
        }
        this.startedServer(this.getLocalPorts());
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteSocket;
    }

    @Override
    public MockServer registerListener(ExpectationsListener expectationsListener) {
        super.registerListener(expectationsListener);
        return this;
    }
}

