/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.xdev.mockserver.event.EventBus;
import software.xdev.mockserver.mock.listeners.MockServerLogListener;
import software.xdev.mockserver.scheduler.Scheduler;

public class MockServerEventLogNotifier {
    private boolean listenerAdded;
    private final List<MockServerLogListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Scheduler scheduler;

    public MockServerEventLogNotifier(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void notifyListeners(EventBus notifier, boolean synchronous) {
        if (this.listenerAdded && !this.listeners.isEmpty()) {
            this.scheduler.submit(() -> {
                for (MockServerLogListener listener : this.listeners.toArray(new MockServerLogListener[0])) {
                    listener.updated(notifier);
                }
            }, synchronous);
        }
    }

    public void registerListener(MockServerLogListener listener) {
        this.listeners.add(listener);
        this.listenerAdded = true;
    }

    public void unregisterListener(MockServerLogListener listener) {
        this.listeners.remove(listener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MockServerEventLogNotifier)) {
            return false;
        }
        MockServerEventLogNotifier that = (MockServerEventLogNotifier)o;
        return this.listenerAdded == that.listenerAdded && Objects.equals(this.listeners, that.listeners) && Objects.equals(this.scheduler, that.scheduler);
    }

    public int hashCode() {
        return Objects.hash(this.listenerAdded, this.listeners, this.scheduler);
    }
}

