/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock.action.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.httpclient.NettyHttpClient;
import software.xdev.mockserver.mock.action.ExpectationCallback;
import software.xdev.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import software.xdev.mockserver.mock.action.ExpectationForwardCallback;
import software.xdev.mockserver.mock.action.http.HttpForwardAction;
import software.xdev.mockserver.mock.action.http.HttpForwardActionResult;
import software.xdev.mockserver.model.HttpClassCallback;
import software.xdev.mockserver.model.HttpRequest;

public class HttpForwardClassCallbackActionHandler
extends HttpForwardAction {
    private static final Logger LOG = LoggerFactory.getLogger(HttpForwardClassCallbackActionHandler.class);

    public HttpForwardClassCallbackActionHandler(NettyHttpClient httpClient) {
        super(httpClient);
    }

    public HttpForwardActionResult handle(HttpClassCallback httpClassCallback, HttpRequest request) {
        return this.invokeCallbackMethod(httpClassCallback, request);
    }

    private <T extends ExpectationCallback> T instantiateCallback(HttpClassCallback httpClassCallback, Class<T> callbackClass) {
        try {
            Class<?> expectationCallbackClass = Class.forName(httpClassCallback.getCallbackClass());
            if (callbackClass.isAssignableFrom(expectationCallbackClass)) {
                Constructor<?> constructor = expectationCallbackClass.getConstructor(new Class[0]);
                return (T)((ExpectationCallback)constructor.newInstance(new Object[0]));
            }
            LOG.warn("{} does not implement {} required for forwarded requests with class callback", (Object)httpClassCallback.getCallbackClass(), (Object)callbackClass.getName());
        }
        catch (ClassNotFoundException e) {
            LOG.error("ClassNotFoundException - while trying to instantiate {} class \"{}\"", new Object[]{callbackClass.getSimpleName(), httpClassCallback.getCallbackClass(), e});
        }
        catch (NoSuchMethodException e) {
            LOG.error("NoSuchMethodException - while trying to create default constructor on {} class \"{}\"", new Object[]{callbackClass.getSimpleName(), httpClassCallback.getCallbackClass(), e});
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error("InvocationTargetException - while trying to execute default constructor on {} class \"{}\"", new Object[]{callbackClass.getSimpleName(), httpClassCallback.getCallbackClass(), e});
        }
        return null;
    }

    private HttpForwardActionResult invokeCallbackMethod(HttpClassCallback httpClassCallback, HttpRequest httpRequest) {
        if (httpRequest != null) {
            ExpectationForwardCallback expectationForwardCallback = this.instantiateCallback(httpClassCallback, ExpectationForwardCallback.class);
            ExpectationForwardAndResponseCallback expectationForwardResponseCallback = this.instantiateCallback(httpClassCallback, ExpectationForwardAndResponseCallback.class);
            if (expectationForwardCallback != null || expectationForwardResponseCallback != null) {
                try {
                    HttpRequest request = expectationForwardCallback != null ? expectationForwardCallback.handle(httpRequest) : httpRequest;
                    return this.sendRequest(request, null, response -> {
                        try {
                            return expectationForwardResponseCallback != null ? expectationForwardResponseCallback.handle(request, response) : response;
                        }
                        catch (Exception ex) {
                            LOG.error("{} throw exception while executing handle callback method", (Object)httpClassCallback.getCallbackClass(), (Object)ex);
                            return response;
                        }
                    });
                }
                catch (Exception ex) {
                    LOG.error("{} throw exception while executing handle callback method", (Object)httpClassCallback.getCallbackClass(), (Object)ex);
                    return this.notFoundFuture(httpRequest);
                }
            }
            return this.sendRequest(httpRequest, null, null);
        }
        return this.notFoundFuture(null);
    }
}

