/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock.action.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.Configuration;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.cors.CORSHeaders;
import software.xdev.mockserver.event.model.EventEntry;
import software.xdev.mockserver.exception.ExceptionHandling;
import software.xdev.mockserver.filters.HopByHopHeaderFilter;
import software.xdev.mockserver.httpclient.NettyHttpClient;
import software.xdev.mockserver.httpclient.SocketCommunicationException;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.mock.HttpState;
import software.xdev.mockserver.mock.action.http.HttpErrorActionHandler;
import software.xdev.mockserver.mock.action.http.HttpForwardActionHandler;
import software.xdev.mockserver.mock.action.http.HttpForwardActionResult;
import software.xdev.mockserver.mock.action.http.HttpForwardClassCallbackActionHandler;
import software.xdev.mockserver.mock.action.http.HttpForwardObjectCallbackActionHandler;
import software.xdev.mockserver.mock.action.http.HttpOverrideForwardedRequestActionHandler;
import software.xdev.mockserver.mock.action.http.HttpResponseActionHandler;
import software.xdev.mockserver.mock.action.http.HttpResponseClassCallbackActionHandler;
import software.xdev.mockserver.mock.action.http.HttpResponseObjectCallbackActionHandler;
import software.xdev.mockserver.model.Action;
import software.xdev.mockserver.model.Delay;
import software.xdev.mockserver.model.HttpClassCallback;
import software.xdev.mockserver.model.HttpError;
import software.xdev.mockserver.model.HttpForward;
import software.xdev.mockserver.model.HttpObjectCallback;
import software.xdev.mockserver.model.HttpOverrideForwardedRequest;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.proxyconfiguration.ProxyConfiguration;
import software.xdev.mockserver.responsewriter.ResponseWriter;
import software.xdev.mockserver.scheduler.Scheduler;
import software.xdev.mockserver.util.StringUtils;

public class HttpActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpActionHandler.class);
    public static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf((String)"REMOTE_SOCKET");
    private final ServerConfiguration configuration;
    private final HttpState httpStateHandler;
    private final Scheduler scheduler;
    private HttpResponseActionHandler httpResponseActionHandler;
    private HttpResponseClassCallbackActionHandler httpResponseClassCallbackActionHandler;
    private HttpResponseObjectCallbackActionHandler httpResponseObjectCallbackActionHandler;
    private HttpForwardActionHandler httpForwardActionHandler;
    private HttpForwardClassCallbackActionHandler httpForwardClassCallbackActionHandler;
    private HttpForwardObjectCallbackActionHandler httpForwardObjectCallbackActionHandler;
    private HttpOverrideForwardedRequestActionHandler httpOverrideForwardedRequestCallbackActionHandler;
    private HttpErrorActionHandler httpErrorActionHandler;
    private final NettyHttpClient httpClient;
    private final HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    public HttpActionHandler(ServerConfiguration configuration, EventLoopGroup eventLoopGroup, HttpState httpStateHandler, List<ProxyConfiguration> proxyConfigurations) {
        this.configuration = configuration;
        this.httpStateHandler = httpStateHandler;
        this.scheduler = httpStateHandler.getScheduler();
        this.httpClient = new NettyHttpClient((Configuration)configuration, eventLoopGroup, proxyConfigurations, true);
    }

    public void processAction(HttpRequest request, ResponseWriter responseWriter, ChannelHandlerContext ctx, Set<String> localAddresses, boolean proxyingRequest, boolean synchronous) {
        boolean potentiallyHttpProxy;
        if (request.getHeaders() == null || !request.getHeaders().containsEntry(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
            this.logEvent(new EventEntry().setType(EventEntry.EventType.RECEIVED_REQUEST).setCorrelationId(request.getLogCorrelationId()).setHttpRequest((RequestDefinition)request));
            LOG.info("received request:{}", (Object)request);
        }
        Expectation expectation = this.httpStateHandler.firstMatchingExpectation(request);
        Runnable expectationPostProcessor = () -> this.httpStateHandler.postProcess(expectation);
        boolean bl = potentiallyHttpProxy = !proxyingRequest && this.configuration.attemptToProxyIfNoMatchingExpectation() != false && !StringUtils.isEmpty((String)request.getFirstHeader(HttpHeaderNames.HOST.toString())) && !localAddresses.contains(request.getFirstHeader(HttpHeaderNames.HOST.toString()));
        if (expectation != null && expectation.getAction() != null) {
            Action action = expectation.getAction();
            switch (action.getType()) {
                case RESPONSE: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpResponse response = this.getHttpResponseActionHandler().handle((HttpResponse)action);
                        this.writeResponseActionResponse(response, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, new Delay[0]);
                    break;
                }
                case RESPONSE_CLASS_CALLBACK: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpResponse response = this.getHttpResponseClassCallbackActionHandler().handle((HttpClassCallback)action, request);
                        this.writeResponseActionResponse(response, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case RESPONSE_OBJECT_CALLBACK: {
                    this.scheduler.schedule(() -> this.getHttpResponseObjectCallbackActionHandler().handle(this, (HttpObjectCallback)action, request, responseWriter, synchronous, expectationPostProcessor), synchronous, action.getDelay());
                    break;
                }
                case FORWARD: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpForwardActionResult responseFuture = this.getHttpForwardActionHandler().handle((HttpForward)action, request);
                        this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case FORWARD_CLASS_CALLBACK: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpForwardActionResult responseFuture = this.getHttpForwardClassCallbackActionHandler().handle((HttpClassCallback)action, request);
                        this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case FORWARD_OBJECT_CALLBACK: {
                    this.scheduler.schedule(() -> this.getHttpForwardObjectCallbackActionHandler().handle(this, (HttpObjectCallback)action, request, responseWriter, synchronous, expectationPostProcessor), synchronous, action.getDelay());
                    break;
                }
                case FORWARD_REPLACE: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        HttpForwardActionResult responseFuture = this.getHttpOverrideForwardedRequestCallbackActionHandler().handle((HttpOverrideForwardedRequest)action, request);
                        this.writeForwardActionResponse(responseFuture, responseWriter, request, action, synchronous);
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                    break;
                }
                case ERROR: {
                    this.scheduler.schedule(() -> this.handleAnyException(request, responseWriter, synchronous, action, () -> {
                        this.getHttpErrorActionHandler().handle((HttpError)action, ctx);
                        this.logEvent(new EventEntry().setType(EventEntry.EventType.EXPECTATION_RESPONSE).setCorrelationId(request.getLogCorrelationId()).setHttpRequest((RequestDefinition)request).setHttpError((HttpError)action).setExpectationId(action.getExpectationId()));
                        LOG.info("Returning error: {} for request: {} for action: {} from expectation: {}", new Object[]{action, request, action, action.getExpectationId()});
                        expectationPostProcessor.run();
                    }), synchronous, action.getDelay());
                }
            }
        } else if (CORSHeaders.isPreflightRequest(this.configuration, request) && (this.configuration.enableCORSForAPI().booleanValue() || this.configuration.enableCORSForAllResponses().booleanValue())) {
            responseWriter.writeResponse(request, HttpResponseStatus.OK);
            if (LOG.isInfoEnabled()) {
                LOG.info("Returning CORS response for OPTIONS request");
            }
        } else if (proxyingRequest || potentiallyHttpProxy) {
            if (request.getHeaders() != null && request.getHeaders().containsEntry(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received \"x-forwarded-by\" header caused by exploratory HTTP proxy or proxy loop - falling back to no proxy: {}", (Object)request);
                }
                this.returnNotFound(responseWriter, request, null);
            } else {
                String username = this.configuration.proxyAuthenticationUsername();
                String password = this.configuration.proxyAuthenticationPassword();
                if (potentiallyHttpProxy && StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password) && !request.containsHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString(), "Basic " + Base64.encode((ByteBuf)Unpooled.copiedBuffer((CharSequence)(username + ":" + password), (Charset)StandardCharsets.UTF_8), (boolean)false).toString(StandardCharsets.US_ASCII))) {
                    HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.code())).withHeader(HttpHeaderNames.PROXY_AUTHENTICATE.toString(), new String[]{"Basic realm=\"" + StringEscapeUtils.escapeJava((String)this.configuration.proxyAuthenticationRealm()) + "\", charset=\"UTF-8\""});
                    responseWriter.writeResponse(request, response, false);
                    LOG.info("Proxy authentication failed so returning response: {} for forwarded request: {}", (Object)response, (Object)request);
                } else {
                    InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress(ctx);
                    HttpRequest clonedRequest = this.hopByHopHeaderFilter.onRequest(request).withHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), new String[]{this.httpStateHandler.getUniqueLoopPreventionHeaderValue()});
                    HttpForwardActionResult responseFuture = new HttpForwardActionResult(clonedRequest, this.httpClient.sendRequest(clonedRequest, remoteAddress, Long.valueOf(potentiallyHttpProxy ? 1000L : this.configuration.socketConnectionTimeoutInMillis())), null, remoteAddress);
                    this.scheduler.submit(responseFuture, () -> {
                        try {
                            HttpResponse response = responseFuture.getHttpResponse().get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                            if (response == null) {
                                response = HttpResponse.notFoundResponse();
                            }
                            if (response.containsHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
                                response.removeHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName());
                                LOG.info("no expectation for: {} returning response: {}", (Object)request, (Object)response);
                                this.logEvent(new EventEntry().setType(EventEntry.EventType.NO_MATCH_RESPONSE).setCorrelationId(request.getLogCorrelationId()).setHttpRequest((RequestDefinition)request).setHttpResponse(HttpResponse.notFoundResponse()));
                            } else {
                                LOG.info("Returning response: {} for forwarded request in json: {}", (Object)request, (Object)response);
                                this.logEvent(new EventEntry().setType(EventEntry.EventType.FORWARDED_REQUEST).setCorrelationId(request.getLogCorrelationId()).setHttpRequest((RequestDefinition)request).setHttpResponse(response).setExpectation((RequestDefinition)request, response));
                            }
                            responseWriter.writeResponse(request, response, false);
                        }
                        catch (SocketCommunicationException sce) {
                            this.returnNotFound(responseWriter, request, sce.getMessage());
                        }
                        catch (Exception ex) {
                            if (potentiallyHttpProxy && ExceptionHandling.connectionException(ex)) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Failed to connect to proxied socket due to exploratory HTTP proxy for: {} due to (see below); Falling back to no proxy", (Object)request, (Object)ex.getCause());
                                }
                                this.returnNotFound(responseWriter, request, null);
                            }
                            if (ExceptionHandling.sslHandshakeException(ex)) {
                                LOG.error("TLS handshake exception while proxying request {} to remote address {} with channel {}", new Object[]{request, remoteAddress, ctx != null ? String.valueOf(ctx.channel()) : "", ex});
                                this.returnNotFound(responseWriter, request, "TLS handshake exception while proxying request to remote address" + String.valueOf(remoteAddress));
                            }
                            if (!ExceptionHandling.connectionClosedException(ex)) {
                                LOG.error("", (Throwable)ex);
                                this.returnNotFound(responseWriter, request, "connection closed while proxying request to remote address" + String.valueOf(remoteAddress));
                            }
                            this.returnNotFound(responseWriter, request, ex.getMessage());
                        }
                    }, synchronous, throwable -> (!potentiallyHttpProxy || !StringUtils.isNotBlank((String)throwable.getMessage())) && throwable.getMessage().contains("Connection refused"));
                }
            }
        } else {
            this.returnNotFound(responseWriter, request, null);
        }
    }

    private void handleAnyException(HttpRequest request, ResponseWriter responseWriter, boolean synchronous, Action action, Runnable processAction) {
        block2: {
            try {
                processAction.run();
            }
            catch (Exception ex) {
                this.writeResponseActionResponse(HttpResponse.notFoundResponse(), responseWriter, request, action, synchronous);
                if (!LOG.isInfoEnabled()) break block2;
                LOG.warn("", (Throwable)ex);
            }
        }
    }

    void writeResponseActionResponse(HttpResponse response, ResponseWriter responseWriter, HttpRequest request, Action action, boolean synchronous) {
        this.scheduler.schedule(() -> {
            this.logEvent(new EventEntry().setType(EventEntry.EventType.EXPECTATION_RESPONSE).setCorrelationId(request.getLogCorrelationId()).setHttpRequest((RequestDefinition)request).setHttpResponse(response).setExpectationId(action.getExpectationId()));
            LOG.info("Returning response: {} for request: {} for action: {} from expectation: {}", new Object[]{response, request, action, action.getExpectationId()});
            responseWriter.writeResponse(request, response, false);
        }, synchronous, response.getDelay());
    }

    void executeAfterForwardActionResponse(HttpForwardActionResult responseFuture, BiConsumer<HttpResponse, Throwable> command, boolean synchronous) {
        this.scheduler.submit(responseFuture, command, synchronous);
    }

    void writeForwardActionResponse(HttpForwardActionResult responseFuture, ResponseWriter responseWriter, HttpRequest request, Action action, boolean synchronous) {
        this.scheduler.submit(responseFuture, () -> {
            try {
                HttpResponse response = responseFuture.getHttpResponse().get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                responseWriter.writeResponse(request, response, false);
                this.logEvent(new EventEntry().setType(EventEntry.EventType.FORWARDED_REQUEST).setCorrelationId(request.getLogCorrelationId()).setHttpRequest((RequestDefinition)request).setHttpResponse(response).setExpectation((RequestDefinition)request, response).setExpectationId(action.getExpectationId()));
                LOG.info("Returning response: {} for forwarded request {} for action: {} from expectation: {}", new Object[]{response, responseFuture.getHttpRequest(), action, action.getExpectationId()});
            }
            catch (Exception ex) {
                this.handleExceptionDuringForwardingRequest(action, request, responseWriter, ex);
            }
        }, synchronous, throwable -> true);
    }

    void writeForwardActionResponse(HttpResponse response, ResponseWriter responseWriter, HttpRequest request, Action action) {
        try {
            responseWriter.writeResponse(request, response, false);
            this.logEvent(new EventEntry().setType(EventEntry.EventType.FORWARDED_REQUEST).setCorrelationId(request.getLogCorrelationId()).setHttpRequest((RequestDefinition)request).setHttpResponse(response).setExpectation((RequestDefinition)request, response).setExpectationId(action.getExpectationId()));
            LOG.info("Returning response: {} for forwarded request in json: {} for action: {} from expectation: {}", new Object[]{response, response, action, action.getExpectationId()});
        }
        catch (Exception ex) {
            LOG.error("", (Throwable)ex);
        }
    }

    void handleExceptionDuringForwardingRequest(Action action, HttpRequest request, ResponseWriter responseWriter, Throwable exception) {
        if (ExceptionHandling.connectionException(exception)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failed to connect to remote socket while forwarding request {}for action {}", (Object)request, (Object)action);
            }
            this.returnNotFound(responseWriter, request, "failed to connect to remote socket while forwarding request");
        } else if (ExceptionHandling.sslHandshakeException(exception)) {
            LOG.error("TLS handshake exception while forwarding request {} for action {}", (Object)request, (Object)action);
            this.returnNotFound(responseWriter, request, "TLS handshake exception while forwarding request");
        } else {
            LOG.error("Failed during request forwarding", exception);
            this.returnNotFound(responseWriter, request, exception != null ? exception.getMessage() : null);
        }
    }

    private void returnNotFound(ResponseWriter responseWriter, HttpRequest request, String error) {
        HttpResponse response = HttpResponse.notFoundResponse();
        if (request.getHeaders() != null && request.getHeaders().containsEntry(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), this.httpStateHandler.getUniqueLoopPreventionHeaderValue())) {
            response.withHeader(this.httpStateHandler.getUniqueLoopPreventionHeaderName(), new String[]{this.httpStateHandler.getUniqueLoopPreventionHeaderValue()});
            if (LOG.isTraceEnabled()) {
                LOG.trace("no expectation for: {} returning response: {}", (Object)request, (Object)HttpResponse.notFoundResponse());
            }
        } else {
            this.logEvent(new EventEntry().setType(EventEntry.EventType.NO_MATCH_RESPONSE).setCorrelationId(request.getLogCorrelationId()).setHttpRequest((RequestDefinition)request).setHttpResponse(HttpResponse.notFoundResponse()));
            if (LOG.isInfoEnabled()) {
                if (StringUtils.isNotBlank((String)error)) {
                    LOG.info("error:{} handling request: {} returning response: {}", new Object[]{error, request, HttpResponse.notFoundResponse()});
                } else {
                    LOG.info("no expectation for: {} returning response: {}", (Object)request, (Object)HttpResponse.notFoundResponse());
                }
            }
        }
        responseWriter.writeResponse(request, response, false);
    }

    private void logEvent(EventEntry entry) {
        this.httpStateHandler.logEvent(entry);
    }

    private HttpResponseActionHandler getHttpResponseActionHandler() {
        if (this.httpResponseActionHandler == null) {
            this.httpResponseActionHandler = new HttpResponseActionHandler();
        }
        return this.httpResponseActionHandler;
    }

    private HttpResponseClassCallbackActionHandler getHttpResponseClassCallbackActionHandler() {
        if (this.httpResponseClassCallbackActionHandler == null) {
            this.httpResponseClassCallbackActionHandler = new HttpResponseClassCallbackActionHandler();
        }
        return this.httpResponseClassCallbackActionHandler;
    }

    private HttpResponseObjectCallbackActionHandler getHttpResponseObjectCallbackActionHandler() {
        if (this.httpResponseObjectCallbackActionHandler == null) {
            this.httpResponseObjectCallbackActionHandler = new HttpResponseObjectCallbackActionHandler(this.httpStateHandler);
        }
        return this.httpResponseObjectCallbackActionHandler;
    }

    private HttpForwardActionHandler getHttpForwardActionHandler() {
        if (this.httpForwardActionHandler == null) {
            this.httpForwardActionHandler = new HttpForwardActionHandler(this.httpClient);
        }
        return this.httpForwardActionHandler;
    }

    private HttpForwardClassCallbackActionHandler getHttpForwardClassCallbackActionHandler() {
        if (this.httpForwardClassCallbackActionHandler == null) {
            this.httpForwardClassCallbackActionHandler = new HttpForwardClassCallbackActionHandler(this.httpClient);
        }
        return this.httpForwardClassCallbackActionHandler;
    }

    private HttpForwardObjectCallbackActionHandler getHttpForwardObjectCallbackActionHandler() {
        if (this.httpForwardObjectCallbackActionHandler == null) {
            this.httpForwardObjectCallbackActionHandler = new HttpForwardObjectCallbackActionHandler(this.httpStateHandler, this.httpClient);
        }
        return this.httpForwardObjectCallbackActionHandler;
    }

    private HttpOverrideForwardedRequestActionHandler getHttpOverrideForwardedRequestCallbackActionHandler() {
        if (this.httpOverrideForwardedRequestCallbackActionHandler == null) {
            this.httpOverrideForwardedRequestCallbackActionHandler = new HttpOverrideForwardedRequestActionHandler(this.httpClient);
        }
        return this.httpOverrideForwardedRequestCallbackActionHandler;
    }

    private HttpErrorActionHandler getHttpErrorActionHandler() {
        if (this.httpErrorActionHandler == null) {
            this.httpErrorActionHandler = new HttpErrorActionHandler();
        }
        return this.httpErrorActionHandler;
    }

    public NettyHttpClient getHttpClient() {
        return this.httpClient;
    }

    public static InetSocketAddress getRemoteAddress(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel() != null && ctx.channel().attr(REMOTE_SOCKET) != null) {
            return (InetSocketAddress)ctx.channel().attr(REMOTE_SOCKET).get();
        }
        return null;
    }

    public static void setRemoteAddress(ChannelHandlerContext ctx, InetSocketAddress inetSocketAddress) {
        if (ctx != null && ctx.channel() != null) {
            ctx.channel().attr(REMOTE_SOCKET).set((Object)inetSocketAddress);
        }
    }
}

