/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import software.xdev.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import software.xdev.mockserver.configuration.Configuration;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.event.EventBus;
import software.xdev.mockserver.event.model.EventEntry;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.mock.RequestMatchers;
import software.xdev.mockserver.mock.listeners.MockServerMatcherNotifier;
import software.xdev.mockserver.model.Action;
import software.xdev.mockserver.model.ClearType;
import software.xdev.mockserver.model.ExpectationId;
import software.xdev.mockserver.model.Format;
import software.xdev.mockserver.model.HttpError;
import software.xdev.mockserver.model.HttpObjectCallback;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.model.RetrieveType;
import software.xdev.mockserver.responsewriter.ResponseWriter;
import software.xdev.mockserver.scheduler.Scheduler;
import software.xdev.mockserver.serialization.ExpectationIdSerializer;
import software.xdev.mockserver.serialization.ExpectationSerializer;
import software.xdev.mockserver.serialization.LogEventRequestAndResponseSerializer;
import software.xdev.mockserver.serialization.RequestDefinitionSerializer;
import software.xdev.mockserver.serialization.VerificationSequenceSerializer;
import software.xdev.mockserver.serialization.VerificationSerializer;
import software.xdev.mockserver.serialization.java.ExpectationToJavaSerializer;
import software.xdev.mockserver.util.StringUtils;
import software.xdev.mockserver.uuid.UUIDService;
import software.xdev.mockserver.verify.Verification;
import software.xdev.mockserver.verify.VerificationSequence;

public class HttpState {
    private static final Logger LOG = LoggerFactory.getLogger(HttpState.class);
    public static final String PATH_PREFIX = "/mockserver";
    private static final ThreadLocal<Integer> LOCAL_PORT = new ThreadLocal();
    private final String uniqueLoopPreventionHeaderValue = "MockServer_" + UUIDService.getUUID();
    private final EventBus eventBus;
    private final Scheduler scheduler;
    private final RequestMatchers requestMatchers;
    private final ServerConfiguration configuration;
    private final WebSocketClientRegistry webSocketClientRegistry;
    private ExpectationIdSerializer expectationIdSerializer;
    private RequestDefinitionSerializer requestDefinitionSerializer;
    private LogEventRequestAndResponseSerializer httpRequestResponseSerializer;
    private ExpectationSerializer expectationSerializer;
    private ExpectationSerializer expectationSerializerThatSerializesBodyDefault;
    private ExpectationToJavaSerializer expectationToJavaSerializer;
    private VerificationSerializer verificationSerializer;
    private VerificationSequenceSerializer verificationSequenceSerializer;

    public static void setPort(HttpRequest request) {
        if (request != null && request.getSocketAddress() != null) {
            HttpState.setPort(request.getSocketAddress().getPort());
            request.withSocketAddress(null);
        }
    }

    public static void setPort(Integer port) {
        LOCAL_PORT.set(port);
    }

    public static void setPort(Integer ... port) {
        if (port != null && port.length > 0) {
            HttpState.setPort(port[0]);
        }
    }

    public static void setPort(List<Integer> port) {
        if (port != null && !port.isEmpty()) {
            HttpState.setPort(port.get(0));
        }
    }

    public static Integer getPort() {
        return LOCAL_PORT.get();
    }

    public HttpState(ServerConfiguration configuration, Scheduler scheduler) {
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.webSocketClientRegistry = new WebSocketClientRegistry((Configuration)configuration);
        LocalCallbackRegistry.setMaxWebSocketExpectations((int)configuration.maxWebSocketExpectations());
        this.eventBus = new EventBus(configuration, scheduler, true);
        this.requestMatchers = new RequestMatchers(configuration, scheduler, this.webSocketClientRegistry);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Log ring buffer created, with size {}", (Object)configuration.ringBufferSize());
        }
    }

    public void clear(HttpRequest request) {
        String logCorrelationId = UUIDService.getUUID();
        RequestDefinition requestDefinition = null;
        ExpectationId expectationId = null;
        if (StringUtils.isNotBlank((String)request.getBodyAsString())) {
            String body = request.getBodyAsJsonOrXmlString();
            try {
                expectationId = this.getExpectationIdSerializer().deserialize(body);
            }
            catch (Exception throwable) {
                requestDefinition = this.getRequestDefinitionSerializer().deserialize(body);
            }
            if (expectationId != null) {
                requestDefinition = this.resolveExpectationId(expectationId);
            }
        }
        if (requestDefinition != null) {
            requestDefinition.withLogCorrelationId(logCorrelationId);
        }
        try {
            ClearType type = ClearType.valueOf((String)StringUtils.defaultIfEmpty((String)request.getFirstQueryStringParameter("type").toUpperCase(), (String)"ALL"));
            switch (type) {
                case LOG: {
                    this.eventBus.clear(requestDefinition);
                    break;
                }
                case EXPECTATIONS: {
                    if (expectationId != null) {
                        this.requestMatchers.clear(expectationId);
                        break;
                    }
                    this.requestMatchers.clear(requestDefinition);
                    break;
                }
                case ALL: {
                    this.eventBus.clear(requestDefinition);
                    if (expectationId != null) {
                        this.requestMatchers.clear(expectationId);
                        break;
                    }
                    this.requestMatchers.clear(requestDefinition);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + String.valueOf(Arrays.stream(ClearType.values()).map(input -> input.name().toLowerCase()).collect(Collectors.toList())), iae);
        }
    }

    private RequestDefinition resolveExpectationId(ExpectationId expectationId) {
        return this.requestMatchers.retrieveRequestDefinitions(Collections.singletonList(expectationId)).findFirst().orElse(null);
    }

    private List<RequestDefinition> resolveExpectationIds(List<ExpectationId> expectationIds) {
        return this.requestMatchers.retrieveRequestDefinitions(expectationIds).collect(Collectors.toList());
    }

    public void reset() {
        this.requestMatchers.reset();
        this.eventBus.reset();
        this.webSocketClientRegistry.reset();
        if (LOG.isInfoEnabled()) {
            LOG.info("Resetting all expectations and request logs");
        }
    }

    public List<Expectation> add(Expectation ... expectations) {
        ArrayList<Expectation> upsertedExpectations = new ArrayList<Expectation>();
        for (Expectation expectation : expectations) {
            upsertedExpectations.add(this.requestMatchers.add(expectation, MockServerMatcherNotifier.Cause.API));
        }
        return upsertedExpectations;
    }

    public Expectation firstMatchingExpectation(HttpRequest request) {
        if (this.requestMatchers.isEmpty()) {
            return null;
        }
        return this.requestMatchers.firstMatchingExpectation(request);
    }

    public List<Expectation> allMatchingExpectation(HttpRequest request) {
        if (this.requestMatchers.isEmpty()) {
            return Collections.emptyList();
        }
        return this.requestMatchers.retrieveActiveExpectations((RequestDefinition)request);
    }

    public void postProcess(Expectation expectation) {
        this.requestMatchers.postProcess(expectation);
    }

    public HttpResponse retrieve(HttpRequest request) {
        String logCorrelationId = UUIDService.getUUID();
        CompletableFuture<HttpResponse> httpResponseFuture = new CompletableFuture<HttpResponse>();
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code()));
        if (request != null) {
            try {
                HttpRequest requestDefinition = StringUtils.isNotBlank((String)request.getBodyAsString()) ? this.getRequestDefinitionSerializer().deserialize(request.getBodyAsJsonOrXmlString()) : HttpRequest.request();
                requestDefinition.withLogCorrelationId(logCorrelationId);
                Format format = Format.valueOf((String)StringUtils.defaultIfEmpty((String)request.getFirstQueryStringParameter("format").toUpperCase(), (String)"JSON"));
                RetrieveType type = RetrieveType.valueOf((String)StringUtils.defaultIfEmpty((String)request.getFirstQueryStringParameter("type").toUpperCase(), (String)"REQUESTS"));
                this.logEvent(new EventEntry().setType(EventEntry.EventType.RETRIEVED).setCorrelationId(logCorrelationId).setHttpRequest((RequestDefinition)requestDefinition));
                switch (type) {
                    case REQUESTS: {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Retrieved requests in {} that match: {}", (Object)format.name().toLowerCase(), (Object)requestDefinition);
                        }
                        switch (format) {
                            case JAVA: {
                                this.eventBus.retrieveRequests((RequestDefinition)requestDefinition, requests -> {
                                    response.withBody(this.getRequestDefinitionSerializer().serialize(requests), MediaType.create((String)"application", (String)"java").withCharset(StandardCharsets.UTF_8));
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case JSON: {
                                this.eventBus.retrieveRequests((RequestDefinition)requestDefinition, requests -> {
                                    response.withBody(this.getRequestDefinitionSerializer().serialize(true, requests), MediaType.JSON_UTF_8);
                                    httpResponseFuture.complete(response);
                                });
                            }
                        }
                        break;
                    }
                    case REQUEST_RESPONSES: {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Retrieved requests and responses in {} that match: {}", (Object)format.name().toLowerCase(), (Object)requestDefinition);
                        }
                        switch (format) {
                            case JAVA: {
                                response.withBody("JAVA not supported for REQUEST_RESPONSES", MediaType.create((String)"text", (String)"plain").withCharset(StandardCharsets.UTF_8));
                                httpResponseFuture.complete(response);
                                break;
                            }
                            case JSON: {
                                this.eventBus.retrieveRequestResponses((RequestDefinition)requestDefinition, httpRequestAndHttpResponses -> {
                                    response.withBody(this.getHttpRequestResponseSerializer().serialize(httpRequestAndHttpResponses), MediaType.JSON_UTF_8);
                                    httpResponseFuture.complete(response);
                                });
                            }
                        }
                        break;
                    }
                    case RECORDED_EXPECTATIONS: {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Retrieved recorded expectations in {} that match: {}", (Object)format.name().toLowerCase(), (Object)requestDefinition);
                        }
                        switch (format) {
                            case JAVA: {
                                this.eventBus.retrieveRecordedExpectations((RequestDefinition)requestDefinition, requests -> {
                                    response.withBody(this.getExpectationToJavaSerializer().serialize((List<Expectation>)requests), MediaType.create((String)"application", (String)"java").withCharset(StandardCharsets.UTF_8));
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case JSON: {
                                this.eventBus.retrieveRecordedExpectations((RequestDefinition)requestDefinition, requests -> {
                                    response.withBody(this.getExpectationSerializerThatSerializesBodyDefault().serialize(requests), MediaType.JSON_UTF_8);
                                    httpResponseFuture.complete(response);
                                });
                            }
                        }
                        break;
                    }
                    case ACTIVE_EXPECTATIONS: {
                        List<Expectation> expectations = this.requestMatchers.retrieveActiveExpectations((RequestDefinition)requestDefinition);
                        switch (format) {
                            case JAVA: {
                                response.withBody(this.getExpectationToJavaSerializer().serialize(expectations), MediaType.create((String)"application", (String)"java").withCharset(StandardCharsets.UTF_8));
                                break;
                            }
                            case JSON: {
                                response.withBody(this.getExpectationSerializer().serialize(expectations), MediaType.JSON_UTF_8);
                            }
                        }
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Retrieved {} active expectations in {} that match: {}", new Object[]{expectations.size(), format.name().toLowerCase(), requestDefinition});
                        }
                        httpResponseFuture.complete(response);
                        break;
                    }
                }
                try {
                    return (HttpResponse)httpResponseFuture.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    LOG.error("Exception handling request: {}", (Object)request, (Object)ex);
                    throw new IllegalStateException("Exception retrieving state for " + String.valueOf(request), ex);
                }
            }
            catch (IllegalArgumentException iae) {
                LOG.error("Exception handling request: {}", (Object)request, (Object)iae);
                if (iae.getMessage().contains(RetrieveType.class.getSimpleName())) {
                    throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + String.valueOf(Arrays.stream(RetrieveType.values()).map(input -> input.name().toLowerCase()).collect(Collectors.toList())));
                }
                if (iae.getMessage().contains(Format.class.getSimpleName())) {
                    throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("format") + "\" is not a valid value for \"format\" parameter, only the following values are supported " + String.valueOf(Arrays.stream(Format.values()).map(input -> input.name().toLowerCase()).collect(Collectors.toList())));
                }
                throw iae;
            }
        }
        return HttpResponse.response().withStatusCode(Integer.valueOf(200));
    }

    public Future<String> verify(Verification verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(Verification verification, Consumer<String> resultConsumer) {
        if (verification.getExpectationId() != null) {
            verification.withRequest(this.resolveExpectationId(verification.getExpectationId()));
        }
        this.eventBus.verify(verification, resultConsumer);
    }

    public Future<String> verify(VerificationSequence verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(VerificationSequence verificationSequence, Consumer<String> resultConsumer) {
        if (verificationSequence.getExpectationIds() != null && !verificationSequence.getExpectationIds().isEmpty()) {
            verificationSequence.withRequests(this.resolveExpectationIds(verificationSequence.getExpectationIds()));
        }
        this.eventBus.verify(verificationSequence, resultConsumer);
    }

    public boolean handle(HttpRequest request, ResponseWriter responseWriter, boolean warDeployment) {
        request.withLogCorrelationId(UUIDService.getUUID());
        HttpState.setPort(request);
        if (LOG.isTraceEnabled()) {
            LOG.trace("received request:{}", (Object)request);
        }
        if (request.matches("PUT")) {
            CompletableFuture<Boolean> canHandle = new CompletableFuture<Boolean>();
            if (request.matchesPath(new String[]{"/mockserver/expectation", "/expectation"})) {
                ArrayList<Expectation> upsertedExpectations = new ArrayList<Expectation>();
                for (Expectation expectation : this.getExpectationSerializer().deserializeArray(request.getBodyAsJsonOrXmlString(), false)) {
                    if (warDeployment && !this.validateSupportedFeatures(expectation, request, responseWriter)) continue;
                    upsertedExpectations.addAll(this.add(expectation));
                }
                responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.CREATED.code())).withBody(this.getExpectationSerializer().serialize(upsertedExpectations), MediaType.JSON_UTF_8), true);
                canHandle.complete(true);
            } else if (request.matchesPath(new String[]{"/mockserver/clear", "/clear"})) {
                this.clear(request);
                responseWriter.writeResponse(request, HttpResponseStatus.OK);
                canHandle.complete(true);
            } else if (request.matchesPath(new String[]{"/mockserver/reset", "/reset"})) {
                this.reset();
                responseWriter.writeResponse(request, HttpResponseStatus.OK);
                canHandle.complete(true);
            } else if (request.matchesPath(new String[]{"/mockserver/retrieve", "/retrieve"})) {
                responseWriter.writeResponse(request, this.retrieve(request), true);
                canHandle.complete(true);
            } else if (request.matchesPath(new String[]{"/mockserver/verify", "/verify"})) {
                this.verify(this.getVerificationSerializer().deserialize(request.getBodyAsJsonOrXmlString()), (String result) -> {
                    if (StringUtils.isEmpty((String)result)) {
                        responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
                    } else {
                        responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, (String)result, MediaType.create((String)"text", (String)"plain").toString());
                    }
                    canHandle.complete(true);
                });
            } else if (request.matchesPath(new String[]{"/mockserver/verifySequence", "/verifySequence"})) {
                this.verify(this.getVerificationSequenceSerializer().deserialize(request.getBodyAsJsonOrXmlString()), (String result) -> {
                    if (StringUtils.isEmpty((String)result)) {
                        responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
                    } else {
                        responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, (String)result, MediaType.create((String)"text", (String)"plain").toString());
                    }
                    canHandle.complete(true);
                });
            } else {
                canHandle.complete(false);
            }
            try {
                return (Boolean)canHandle.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                LOG.error("Exception handling request: {}", (Object)request, (Object)ex);
                return false;
            }
        }
        return false;
    }

    private boolean validateSupportedFeatures(Expectation expectation, HttpRequest request, ResponseWriter responseWriter) {
        boolean valid = true;
        Action action = expectation.getAction();
        String notSupportedMessage = " is not supported by MockServer deployed as a WAR due to limitations in the JEE specification; use mockserver-netty to enable these features";
        if (action instanceof HttpResponse && ((HttpResponse)action).getConnectionOptions() != null) {
            valid = false;
            responseWriter.writeResponse(request, HttpResponse.response((String)"ConnectionOptions is not supported by MockServer deployed as a WAR due to limitations in the JEE specification; use mockserver-netty to enable these features"), true);
        } else if (action instanceof HttpObjectCallback) {
            valid = false;
            responseWriter.writeResponse(request, HttpResponse.response((String)"HttpObjectCallback is not supported by MockServer deployed as a WAR due to limitations in the JEE specification; use mockserver-netty to enable these features"), true);
        } else if (action instanceof HttpError) {
            valid = false;
            responseWriter.writeResponse(request, HttpResponse.response((String)"HttpError is not supported by MockServer deployed as a WAR due to limitations in the JEE specification; use mockserver-netty to enable these features"), true);
        }
        return valid;
    }

    public WebSocketClientRegistry getWebSocketClientRegistry() {
        return this.webSocketClientRegistry;
    }

    public RequestMatchers getRequestMatchers() {
        return this.requestMatchers;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void logEvent(EventEntry entry) {
        this.getEventBus().add(entry);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public String getUniqueLoopPreventionHeaderName() {
        return "x-forwarded-by";
    }

    public String getUniqueLoopPreventionHeaderValue() {
        return this.uniqueLoopPreventionHeaderValue;
    }

    public void stop() {
        this.eventBus.stop();
    }

    private ExpectationIdSerializer getExpectationIdSerializer() {
        if (this.expectationIdSerializer == null) {
            this.expectationIdSerializer = new ExpectationIdSerializer();
        }
        return this.expectationIdSerializer;
    }

    private RequestDefinitionSerializer getRequestDefinitionSerializer() {
        if (this.requestDefinitionSerializer == null) {
            this.requestDefinitionSerializer = new RequestDefinitionSerializer();
        }
        return this.requestDefinitionSerializer;
    }

    private LogEventRequestAndResponseSerializer getHttpRequestResponseSerializer() {
        if (this.httpRequestResponseSerializer == null) {
            this.httpRequestResponseSerializer = new LogEventRequestAndResponseSerializer();
        }
        return this.httpRequestResponseSerializer;
    }

    private ExpectationSerializer getExpectationSerializer() {
        if (this.expectationSerializer == null) {
            this.expectationSerializer = new ExpectationSerializer();
        }
        return this.expectationSerializer;
    }

    private ExpectationSerializer getExpectationSerializerThatSerializesBodyDefault() {
        if (this.expectationSerializerThatSerializesBodyDefault == null) {
            this.expectationSerializerThatSerializesBodyDefault = new ExpectationSerializer(true);
        }
        return this.expectationSerializerThatSerializesBodyDefault;
    }

    private ExpectationToJavaSerializer getExpectationToJavaSerializer() {
        if (this.expectationToJavaSerializer == null) {
            this.expectationToJavaSerializer = new ExpectationToJavaSerializer();
        }
        return this.expectationToJavaSerializer;
    }

    private VerificationSerializer getVerificationSerializer() {
        if (this.verificationSerializer == null) {
            this.verificationSerializer = new VerificationSerializer();
        }
        return this.verificationSerializer;
    }

    private VerificationSequenceSerializer getVerificationSequenceSerializer() {
        if (this.verificationSequenceSerializer == null) {
            this.verificationSequenceSerializer = new VerificationSequenceSerializer();
        }
        return this.verificationSequenceSerializer;
    }
}

