/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import java.util.Objects;
import software.xdev.mockserver.codec.ExpandedParameterDecoder;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.matchers.BodyMatcher;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.MultiValueMapMatcher;
import software.xdev.mockserver.model.KeyToMultiValue;
import software.xdev.mockserver.model.KeysToMultiValues;
import software.xdev.mockserver.model.Parameters;

public class ParameterStringMatcher
extends BodyMatcher<String> {
    private final MultiValueMapMatcher matcher;
    private final ExpandedParameterDecoder formParameterParser;
    private final Parameters matcherParameters;
    private final ExpandedParameterDecoder expandedParameterDecoder;

    ParameterStringMatcher(ServerConfiguration configuration, Parameters matcherParameters, boolean controlPlaneMatcher) {
        this.matcherParameters = matcherParameters;
        this.matcher = new MultiValueMapMatcher((KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues>)matcherParameters, controlPlaneMatcher);
        this.formParameterParser = new ExpandedParameterDecoder(configuration);
        this.expandedParameterDecoder = new ExpandedParameterDecoder(configuration);
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result = false;
        Parameters matchedParameters = this.formParameterParser.retrieveFormParameters(matched, matched != null && matched.contains("?"));
        this.expandedParameterDecoder.splitParameters(this.matcherParameters, matchedParameters);
        if (this.matcher.matches(context, (KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues>)matchedParameters)) {
            result = true;
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher.isBlank();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterStringMatcher)) {
            return false;
        }
        ParameterStringMatcher that = (ParameterStringMatcher)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.matcher, that.matcher) && Objects.equals(this.formParameterParser, that.formParameterParser) && Objects.equals(this.matcherParameters, that.matcherParameters) && Objects.equals(this.expandedParameterDecoder, that.expandedParameterDecoder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.matcher, this.formParameterParser, this.matcherParameters, this.expandedParameterDecoder);
    }
}

