/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import java.net.SocketAddress;
import java.util.List;
import software.xdev.mockserver.codec.PreserveHeadersNettyRemoves;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.mappers.FullHttpRequestToMockServerHttpRequest;
import software.xdev.mockserver.model.Header;

public class NettyHttpToMockServerHttpRequestDecoder
extends MessageToMessageDecoder<FullHttpRequest> {
    private final FullHttpRequestToMockServerHttpRequest fullHttpRequestToMockServerRequest;

    public NettyHttpToMockServerHttpRequestDecoder(ServerConfiguration configuration, Integer port) {
        this.fullHttpRequestToMockServerRequest = new FullHttpRequestToMockServerHttpRequest(configuration, port);
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest, List<Object> out) {
        List<Header> preservedHeaders = null;
        SocketAddress localAddress = null;
        SocketAddress remoteAddress = null;
        if (ctx != null && ctx.channel() != null) {
            preservedHeaders = PreserveHeadersNettyRemoves.preservedHeaders(ctx.channel());
            localAddress = ctx.channel().localAddress();
            remoteAddress = ctx.channel().remoteAddress();
        }
        out.add(this.fullHttpRequestToMockServerRequest.mapFullHttpRequestToMockServerRequest(fullHttpRequest, preservedHeaders, localAddress, remoteAddress));
    }
}

