/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import software.amazon.smithy.utils.CycleException;
import software.amazon.smithy.utils.SetUtils;

public class DependencyGraph<T>
implements Collection<T>,
Iterable<T> {
    private final Map<T, Set<T>> forwardDependencies;
    private final Map<T, Set<T>> reverseDependencies;

    public DependencyGraph(int initialCapacity) {
        this.forwardDependencies = new LinkedHashMap<T, Set<T>>(initialCapacity);
        this.reverseDependencies = new LinkedHashMap<T, Set<T>>(initialCapacity);
    }

    public DependencyGraph(Collection<T> c) {
        this(c.size());
        this.addAll(c);
    }

    public DependencyGraph() {
        this(16);
    }

    @Override
    public boolean add(T t) {
        if (this.forwardDependencies.containsKey(t)) {
            return false;
        }
        this.forwardDependencies.put(t, new LinkedHashSet());
        this.reverseDependencies.put(t, new LinkedHashSet());
        return true;
    }

    public void addDependency(T what, T dependsOn) {
        if (!this.forwardDependencies.containsKey(what)) {
            this.add(what);
        }
        if (!this.forwardDependencies.containsKey(dependsOn)) {
            this.add(dependsOn);
        }
        this.forwardDependencies.get(what).add(dependsOn);
        this.reverseDependencies.get(dependsOn).add(what);
    }

    public void addDependencies(T what, Collection<T> dependsOn) {
        if (!this.forwardDependencies.containsKey(what)) {
            this.add(what);
        }
        Set<T> dependencies = this.forwardDependencies.get(what);
        for (T dependency : dependsOn) {
            if (dependencies.contains(dependency)) continue;
            if (!this.forwardDependencies.containsKey(dependency)) {
                this.add(dependency);
            }
            dependencies.add(dependency);
            this.reverseDependencies.get(dependency).add(what);
        }
    }

    public void setDependencies(T what, Collection<T> dependsOn) {
        Set<T> current = this.forwardDependencies.get(what);
        if (current != null && !current.isEmpty()) {
            ArrayList<T> toRemove = new ArrayList<T>();
            for (T dependency : current) {
                if (dependsOn.contains(dependency)) continue;
                toRemove.add(dependency);
            }
            this.removeDependencies(what, toRemove);
        }
        this.addDependencies(what, dependsOn);
    }

    @Override
    public boolean remove(Object o) {
        if (!this.forwardDependencies.containsKey(o)) {
            return false;
        }
        for (T dependant : this.reverseDependencies.get(o)) {
            this.forwardDependencies.get(dependant).remove(o);
        }
        this.forwardDependencies.remove(o);
        this.reverseDependencies.remove(o);
        return true;
    }

    public void removeDependency(T what, T dependsOn) {
        this.forwardDependencies.get(what).remove(dependsOn);
        this.reverseDependencies.get(dependsOn).remove(what);
    }

    public void removeDependencies(T what, Collection<T> dependsOn) {
        this.forwardDependencies.get(what).removeAll(dependsOn);
        for (T dependency : dependsOn) {
            this.reverseDependencies.get(dependency).remove(what);
        }
    }

    public Set<T> getIndependentNodes() {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (Map.Entry<T, Set<T>> node : this.forwardDependencies.entrySet()) {
            if (!node.getValue().isEmpty()) continue;
            result.add(node.getKey());
        }
        return result;
    }

    public Set<T> getDirectDependencies(T node) {
        Set<T> result = this.forwardDependencies.get(node);
        if (result == null) {
            return null;
        }
        return SetUtils.copyOf(result);
    }

    public Set<T> getDirectDependants(T node) {
        Set<T> result = this.reverseDependencies.get(node);
        if (result == null) {
            return null;
        }
        return SetUtils.copyOf(result);
    }

    public List<List<T>> findCycles() {
        ArrayList<List<T>> cycles = new ArrayList<List<T>>();
        HashMap indexes = new HashMap(this.size());
        HashMap lowLinks = new HashMap(this.size());
        ArrayDeque stack = new ArrayDeque(this.size());
        HashSet onStack = new HashSet(this.size());
        int index = 0;
        for (T node : this.reverseDependencies.keySet()) {
            if (indexes.containsKey(node)) continue;
            index = this.strongConnect(node, indexes, lowLinks, stack, onStack, cycles, index);
        }
        return cycles;
    }

    private int strongConnect(T current, Map<T, Integer> indexes, Map<T, Integer> lowLinks, Deque<T> stack, Set<T> onStack, List<List<T>> cycles, int index) {
        indexes.put(current, index);
        lowLinks.put(current, index);
        ++index;
        stack.push(current);
        onStack.add(current);
        for (T dependent : this.reverseDependencies.get(current)) {
            if (!indexes.containsKey(dependent)) {
                index = this.strongConnect(dependent, indexes, lowLinks, stack, onStack, cycles, index);
                lowLinks.put(current, Math.min(lowLinks.get(current), lowLinks.get(dependent)));
                continue;
            }
            if (!onStack.contains(dependent)) continue;
            lowLinks.put(current, Math.min(lowLinks.get(current), indexes.get(dependent)));
        }
        if (lowLinks.get(current).equals(indexes.get(current))) {
            T node;
            ArrayList<T> cycle = new ArrayList<T>();
            do {
                node = stack.pop();
                onStack.remove(node);
                cycle.add(node);
            } while (!node.equals(current));
            if (cycle.size() > 1) {
                cycles.add(cycle);
            }
        }
        return index;
    }

    @Override
    public int size() {
        return this.forwardDependencies.size();
    }

    @Override
    public boolean isEmpty() {
        return this.forwardDependencies.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.forwardDependencies.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.forwardDependencies.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.forwardDependencies.keySet().toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.forwardDependencies.keySet().toArray(a);
    }

    public List<T> toSortedList() {
        return this.toSortedList(new ArrayDeque());
    }

    public List<T> toSortedList(Comparator<T> comparator) {
        return this.toSortedList(new PriorityQueue<T>(comparator));
    }

    private List<T> toSortedList(Queue<T> satisfied) {
        HashMap<T, Integer> inDegree = new HashMap<T, Integer>(this.forwardDependencies.size());
        for (Map.Entry<T, Set<T>> entry : this.forwardDependencies.entrySet()) {
            int degree = entry.getValue().size();
            inDegree.put(entry.getKey(), degree);
            if (!entry.getValue().isEmpty()) continue;
            satisfied.offer(entry.getKey());
        }
        ArrayList<T> result = new ArrayList<T>(this.forwardDependencies.size());
        while (!satisfied.isEmpty()) {
            T node = satisfied.poll();
            result.add(node);
            for (T dependent : this.reverseDependencies.get(node)) {
                int newCount = (Integer)inDegree.get(dependent) - 1;
                inDegree.put(dependent, newCount);
                if (newCount != 0) continue;
                satisfied.add(dependent);
            }
        }
        if (result.size() != this.reverseDependencies.size()) {
            LinkedHashSet<T> remaining = new LinkedHashSet<T>(this.reverseDependencies.size() - result.size());
            for (T node : this.reverseDependencies.keySet()) {
                if (result.contains(node)) continue;
                remaining.add(node);
            }
            throw new CycleException(result, remaining);
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.forwardDependencies.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T element : c) {
            changed = this.add(element) || changed;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object element : c) {
            changed = this.remove(element) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<T> toRemove = new ArrayList<T>();
        for (T element : this.forwardDependencies.keySet()) {
            if (c.contains(element)) continue;
            toRemove.add(element);
        }
        return this.removeAll(toRemove);
    }

    @Override
    public void clear() {
        this.forwardDependencies.clear();
        this.reverseDependencies.clear();
    }
}

