/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.utils.CopyOnWriteRef;
import software.amazon.smithy.utils.DefaultBuilderRef;

public interface BuilderRef<T>
extends CopyOnWriteRef<T> {
    public T copy();

    public boolean hasValue();

    public void clear();

    public static <K, V> BuilderRef<Map<K, V>> forUnorderedMap() {
        return new DefaultBuilderRef<Map<K, V>>(HashMap::new, HashMap::new, Collections::unmodifiableMap, Collections::emptyMap);
    }

    public static <K, V> BuilderRef<Map<K, V>> forOrderedMap() {
        return new DefaultBuilderRef<Map<K, V>>(LinkedHashMap::new, LinkedHashMap::new, Collections::unmodifiableMap, Collections::emptyMap);
    }

    public static <T> BuilderRef<List<T>> forList() {
        return new DefaultBuilderRef<List<T>>(ArrayList::new, ArrayList::new, Collections::unmodifiableList, Collections::emptyList);
    }

    public static <T> BuilderRef<Set<T>> forUnorderedSet() {
        return new DefaultBuilderRef<Set<T>>(HashSet::new, HashSet::new, Collections::unmodifiableSet, Collections::emptySet);
    }

    public static <T> BuilderRef<Set<T>> forOrderedSet() {
        return new DefaultBuilderRef<Set<T>>(LinkedHashSet::new, LinkedHashSet::new, Collections::unmodifiableSet, Collections::emptySet);
    }
}

