/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public final class IoUtils {
    private static final int BUFFER_SIZE = 4096;

    private IoUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(InputStream is) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int n;
            byte[] b = new byte[4096];
            while ((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String toUtf8String(InputStream is) {
        return new String(IoUtils.toByteArray(is), StandardCharsets.UTF_8);
    }

    public static String readUtf8File(String path) {
        return IoUtils.readUtf8File(Paths.get(path, new String[0]));
    }

    public static String readUtf8File(Path path) {
        try {
            return new String(Files.readAllBytes(path.toRealPath(new LinkOption[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String readUtf8Resource(ClassLoader classLoader, String resourcePath) {
        return IoUtils.readUtf8Url(classLoader.getResource(resourcePath));
    }

    public static String readUtf8Resource(Class<?> clazz, String resourcePath) {
        return IoUtils.readUtf8Url(clazz.getResource(resourcePath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readUtf8Url(URL url) {
        try (InputStream is = url.openStream();){
            String string = IoUtils.toUtf8String(is);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String runCommand(String command) {
        return IoUtils.runCommand(command, Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    public static String runCommand(String command, Path directory) {
        StringBuilder sb = new StringBuilder();
        int exitValue = IoUtils.runCommand(command, directory, sb);
        if (exitValue != 0) {
            throw new RuntimeException(String.format("Command `%s` failed with exit code %d and output:%n%n%s", command, exitValue, sb.toString()));
        }
        return sb.toString();
    }

    public static int runCommand(String command, Path directory, Appendable output) {
        String[] finalizedCommand = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows") ? new String[]{"cmd.exe", "/c", command} : new String[]{"sh", "-c", command};
        ProcessBuilder processBuilder = new ProcessBuilder(finalizedCommand).directory(directory.toFile()).redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    output.append(line).append(System.lineSeparator());
                }
            }
            process.waitFor();
            process.destroy();
            return process.exitValue();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

