/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.node.TimestampValidationStrategy;
import software.amazon.smithy.protocoltests.traits.HttpMessageTestCase;

abstract class ProtocolTestCaseValidator<T extends Trait>
extends AbstractValidator {
    private final Class<T> traitClass;
    private final ShapeId traitId;
    private final String descriptor;

    ProtocolTestCaseValidator(ShapeId traitId, Class<T> traitClass, String descriptor) {
        this.traitId = traitId;
        this.traitClass = traitClass;
        this.descriptor = descriptor;
    }

    public List<ValidationEvent> validate(Model model) {
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        return Stream.concat(model.shapes(OperationShape.class), model.shapes(StructureShape.class)).flatMap(operation -> Trait.flatMapStream((Shape)operation, this.traitClass)).flatMap(pair -> this.validateOperation(model, operationIndex, (Shape)pair.left, (Trait)pair.right).stream()).collect(Collectors.toList());
    }

    abstract StructureShape getStructure(Shape var1, OperationIndex var2);

    abstract List<? extends HttpMessageTestCase> getTestCases(T var1);

    boolean isValidatedBy(Shape shape) {
        return shape instanceof OperationShape;
    }

    private List<ValidationEvent> validateOperation(Model model, OperationIndex operationIndex, Shape shape, T trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        List<HttpMessageTestCase> testCases = this.getTestCases(trait);
        for (int i = 0; i < testCases.size(); ++i) {
            HttpMessageTestCase testCase = testCases.get(i);
            StructureShape struct = this.getStructure(shape, operationIndex);
            if (struct != null) {
                NodeValidationVisitor validator = this.createVisitor(testCase.getParams(), model, shape, i);
                events.addAll((Collection)struct.accept((ShapeVisitor)validator));
                continue;
            }
            if (testCase.getParams().isEmpty() || !this.isValidatedBy(shape)) continue;
            events.add(this.error(shape, (FromSourceLocation)trait, String.format("Protocol test %s parameters provided for operation with no %s: `%s`", this.descriptor, this.descriptor, Node.printJson((Node)testCase.getParams()))));
        }
        return events;
    }

    private NodeValidationVisitor createVisitor(ObjectNode value, Model model, Shape shape, int position) {
        return NodeValidationVisitor.builder().model(model).eventShapeId(shape.getId()).value((Node)value).startingContext(this.traitId + "." + position + ".params").eventId(this.getName()).timestampValidationStrategy(TimestampValidationStrategy.EPOCH_SECONDS).allowBoxedNull(true).build();
    }
}

